package com.clx.performance.job;

import cn.hutool.json.JSONUtil;
import com.clx.order.feign.LoanPaymentFeign;
import com.clx.order.vo.pc.nbbank.NbBankOrderPayStatusResultVO;
import com.clx.performance.dao.loan.OwnerPaymentDao;
import com.clx.performance.enums.loan.OwnerPaymentEnum;
import com.clx.performance.model.loan.OwnerPayment;
import com.msl.common.result.Result;
import com.xxl.job.core.handler.annotation.XxlJob;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;

@Slf4j
@Component
@AllArgsConstructor
public class OwnerPaymentPayStatusJob {


    private final OwnerPaymentDao ownerPaymentDao;

    private final LoanPaymentFeign loanPaymentFeign;

    /**
     * 货主付款支付状态
     */
    @XxlJob("ownerPaymentPayStatusJob")
    public void ownerPaymentPayStatusJob() {
        log.info("货主付款支付状态定时器执行");
        List<OwnerPayment> ownerPaymentList = ownerPaymentDao.selectListByPayStatus(OwnerPaymentEnum.Status.PAYING.getCode());
        if (CollectionUtils.isEmpty(ownerPaymentList)) {
            log.info("当前未存在付款中的付款单");
        }

        for (OwnerPayment ownerPayment : ownerPaymentList) {
            Result<NbBankOrderPayStatusResultVO> result = loanPaymentFeign.getResult(ownerPayment.getMerchantRunningWaterNo());
            log.info("货主付款支付状态定时器执行,货主付款单流水号:{},查询结果:{}", ownerPayment.getMerchantRunningWaterNo(), JSONUtil.parse(result));
            if (!result.succeed()) {
                continue;
            }
            NbBankOrderPayStatusResultVO data = result.getData();
            if (data.getStatus() == 1) {
                ownerPaymentDao.updatePayStatus(ownerPayment.getId(), OwnerPaymentEnum.Status.PAY_SUCCESS.getCode());
            } else {
                ownerPaymentDao.updatePayStatus(ownerPayment.getId(), OwnerPaymentEnum.Status.PAY_FAIL.getCode());
            }
        }
    }
}
