package com.clx.performance.controller.pc;

import com.clx.performance.param.pc.SaveOrderChildOperateLimitConfigParam;
import com.clx.performance.service.OrderChildOperateLimitConfigService;
import com.clx.performance.vo.pc.OrderChildOperateLimitConfigVO;
import com.msl.common.convertor.aspect.UnitCovert;
import com.msl.common.result.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotNull;

/**
 * @author jiangwujie
 */
@Slf4j
@RestController
@RequestMapping(value = "/pc/carrier/orderChildOperateLimitConfig")
@Validated
@Api(tags = "运单操作限制配置")
@AllArgsConstructor
public class OrderChildOperateLimitConfigController {

    private final OrderChildOperateLimitConfigService orderChildOperateLimitService;

    @ApiOperation(value = "运单操作限制配置列表", notes = "<br>By:姜武杰")
    @GetMapping("/listConfig")
    @UnitCovert(param = false)
    public Result<OrderChildOperateLimitConfigVO> listConfig() {
        return Result.ok(orderChildOperateLimitService.listConfig());
    }

    @ApiOperation(value = "运单操作限制配置详情", notes = "<br>By:姜武杰")
    @GetMapping("/getDetail")
    @UnitCovert(param = false)
    public Result<OrderChildOperateLimitConfigVO> getDetail(@NotNull(message = "id不能为空") Integer id) {
        return Result.ok(orderChildOperateLimitService.getDetail(id));
    }

    @ApiOperation(value = "编辑运单操作限制配置", notes = "<br>By:姜武杰")
    @PostMapping("/update")
    @UnitCovert
    public Result updateConfig(@RequestBody @Validated SaveOrderChildOperateLimitConfigParam param) {
        orderChildOperateLimitService.updateConfig(param);
        return Result.ok();
    }

    @ApiOperation(value = "运单操作限制配置启用", notes = "<br>By:姜武杰")
    @PostMapping("/enable")
    @UnitCovert
    public Result enableConfig(@NotNull(message = "id不能为空") Integer id) {
        orderChildOperateLimitService.enableConfig(id);
        return Result.ok();
    }

    @ApiOperation(value = "运单操作限制配置禁用", notes = "<br>By:姜武杰")
    @PostMapping("/disable")
    @UnitCovert
    public Result disableConfig(@NotNull(message = "id不能为空") Integer id) {
        orderChildOperateLimitService.disableConfig(id);
        return Result.ok();
    }


}
