package com.clx.performance.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Optional;

@Getter
@AllArgsConstructor
@SuppressWarnings("all")
public enum NetworkDriverAccountEnum {
    ;


    @Getter
    @AllArgsConstructor
    public enum RunningWaterStatus {
        SETTLEMENT(10, "运单结算"),
        CASE_OUT_FROZEN(20, "提现冻结"),
        CASE_OUT_SUCCESS(30, "提现成功"),

        ;
        private final Integer code;
        private final String msg;
        public static Optional<NetworkDriverAccountEnum.RunningWaterStatus> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> e.code.equals(code)).findFirst();
        }

        public Integer getCode() {
            return this.code;
        }

        public String getMsg() {
            return this.msg;
        }
    }

    @Getter
    @AllArgsConstructor
    public enum FundType {
        INCOME(10, "收入"),
        FROZEN(20, "冻结"),
        EXPENDITURE(30, "支出"),

        ;
        private final Integer code;
        private final String msg;
        public static Optional<NetworkDriverAccountEnum.FundType> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> e.code.equals(code)).findFirst();
        }

        public Integer getCode() {
            return this.code;
        }

        public String getMsg() {
            return this.msg;
        }
    }

    @Getter
    @AllArgsConstructor
    public enum CaseOutRecordStatus {
        WAIT_PLATFORM_PAY(10, "待平台付款"),
        PAYED(20, "已付款"),
        ;
        private final Integer code;
        private final String msg;
        public static Optional<CaseOutRecordStatus> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> e.code.equals(code)).findFirst();
        }

        public Integer getCode() {
            return this.code;
        }

        public String getMsg() {
            return this.msg;
        }
    }
}
