package com.clx.performance.vo.pc.loan.carrier;

import com.msl.common.convertor.type.MoneyOutConvert;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;

import java.math.BigDecimal;
import java.util.List;

/**
 * @ClassName CashierInfoVO
 * @Description
 * @Author kavin
 * @Date 2024/1/24 16:24
 * @Version 1.0
 */

@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class CarrierCashierInfoVO {

    @ApiModelProperty("借款单号")
    private Long loanNo;

    @ApiModelProperty("货物名称")
    private String goodsName;


    @ApiModelProperty("交易流水号（第三方）")
    private String runningWaterOpenNo;

    @MoneyOutConvert
    @ApiModelProperty("订单金额")
    private BigDecimal loanBalance;

    @ApiModelProperty("是否有订单支付方式 true:有  false:没有")
    private Boolean orderPayWay;


    @ApiModelProperty("付款账户")
    private String payAccount;


    @ApiModelProperty("银行名称")
    private String bankName;

}
