/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.crypto.tls;

import cn.com.infosec.asn1.ASN1InputStream;
import cn.com.infosec.asn1.DERObject;
import cn.com.infosec.asn1.x509.X509CertificateStructure;
import cn.com.infosec.crypto.tls.TlsUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public class Certificate {
    protected X509CertificateStructure[] certs;

    protected static Certificate parse(InputStream is) throws IOException {
        int size;
        Vector<X509CertificateStructure> tmp = new Vector<X509CertificateStructure>();
        for (int left = TlsUtils.readUint24(is); left > 0; left -= 3 + size) {
            size = TlsUtils.readUint24(is);
            byte[] buf = new byte[size];
            TlsUtils.readFully(buf, is);
            ByteArrayInputStream bis = new ByteArrayInputStream(buf);
            ASN1InputStream ais = new ASN1InputStream(bis);
            DERObject o = ais.readObject();
            tmp.addElement(X509CertificateStructure.getInstance(o));
            if (bis.available() <= 0) continue;
            throw new IllegalArgumentException("Sorry, there is garbage data left after the certificate");
        }
        X509CertificateStructure[] certs = new X509CertificateStructure[tmp.size()];
        int i = 0;
        while (i < tmp.size()) {
            certs[i] = (X509CertificateStructure)tmp.elementAt(i);
            ++i;
        }
        return new Certificate(certs);
    }

    private Certificate(X509CertificateStructure[] certs) {
        this.certs = certs;
    }

    public X509CertificateStructure[] getCerts() {
        X509CertificateStructure[] result = new X509CertificateStructure[this.certs.length];
        System.arraycopy(this.certs, 0, result, 0, this.certs.length);
        return result;
    }
}

