package com.clx.performance.controller.pc;

import cn.hutool.json.JSONUtil;
import com.clx.performance.service.LargeScreenService;
import com.clx.performance.service.OrderChildService;
import com.clx.user.feign.DriverFeign;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@Slf4j
@RestController
@RequestMapping("/pc/largescreen")
@Validated
@AllArgsConstructor
@Api(tags = "PC-大屏")
public class LargeScreenController {

    private final LargeScreenService largeScreenService;


    @ApiOperation(value = "空车列表", notes = "<br>By:胡宇帆")
    @GetMapping("/emptyCarList")
    public String emptyCarList() {
        return JSONUtil.toJsonStr(largeScreenService.emptyCarList());
    }

    @ApiOperation(value = "重车列表", notes = "<br>By:胡宇帆")
    @GetMapping("/weightCarList")
    public String weightCarList() {
        return JSONUtil.toJsonStr(largeScreenService.weightCarList());
    }

    @ApiOperation(value = "收货地址", notes = "<br>By:胡宇帆")
    @GetMapping("/receiveAddress")
    public String receiveAddress(@RequestParam(value = "addressId") Integer addressId) {
        return largeScreenService.receiveAddress(addressId);
    }

    @ApiOperation(value = "发货地址", notes = "<br>By:胡宇帆")
    @GetMapping("/sendAddress")
    public String sendAddress(@RequestParam(value = "addressId") Integer addressId) {
        return largeScreenService.sendAddress(addressId);
    }

    @ApiOperation(value = "线路", notes = "<br>By:胡宇帆")
    @GetMapping("/lineString")
    public String lineString(@RequestParam(value = "addressId") Integer addressId) {
        return largeScreenService.routeLine(addressId);
    }

}