package com.clx.performance.listener.child;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.clx.performance.common.MqWrapper;
import com.clx.performance.constant.RabbitKeyOrderChildConstants;
import com.clx.performance.service.OrderChildMqHandlerService;
import com.clx.performance.vo.mq.OrderChildDriverConfirmMqParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @Author: 艾庆国
 * @Description: 运单司机确认收货 mq
 * @Date: 2023-10-20 17:39:27
 * @Version: 1.0
 */
@Slf4j
@Component
public class OrderChildDriverConfirmListener {

    @Autowired
    private OrderChildMqHandlerService orderChildMqHandlerService;

    @RabbitListener(queues = RabbitKeyOrderChildConstants.ORDER_CHILD_DRIVER_CONFIRM_QUEUE)
    public void process(Message message) {
        try{
            log.info("运单-司机确认收货, message:{}", new String(message.getBody()));
            process(JSON.parseObject(new String(message.getBody()), new TypeReference<MqWrapper<OrderChildDriverConfirmMqParam>>(){}).getData());
        }catch (Exception e){
            log.info("运单-司机确认收货 失败",e);
        }
    }

    private void process(OrderChildDriverConfirmMqParam mq){

        orderChildMqHandlerService.orderChildDriverConfirm(mq);

    }

}
