package com.clx.performance.dao.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.clx.performance.dao.TruckPositionDao;
import com.clx.performance.mapper.TruckPositionMapper;
import com.clx.performance.model.TruckPosition;
import com.msl.common.dao.impl.BaseDaoImpl;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 车辆位置;
 *
 * @author : jiangwenye
 * @date : 2024-05-29
 */
@Repository
public class TruckPositionDaoImpl extends BaseDaoImpl<TruckPositionMapper, TruckPosition, Integer>
        implements TruckPositionDao {

    @Override
    public void updateTruckPositionStatus(Integer deleteStatus, List<String> truckNoList) {
        update(lUdWrapper()
                .set(TruckPosition::getDeleteStatus, deleteStatus)
                .notIn(CollectionUtil.isNotEmpty(truckNoList), TruckPosition::getTruckNo, truckNoList)
        );
    }

    @Override
    public void replaceTruckPosition(List<TruckPosition> truckPositionList) {
        baseMapper.replaceTruckPosition(truckPositionList);
    }
}
