package com.clx.performance.param.app.breakcontract;

import com.msl.common.base.PageParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import javax.validation.constraints.NotNull;

@Getter
@Setter
@NoArgsConstructor
@ToString
public class DriverPageBreakContractDriverRecordParam extends PageParam {

    @ApiModelProperty(value = "类型：1违约记录 2平台补偿 ", example = "1")
    @NotNull(message = "类型不能为空")
    private Integer type;

    @ApiModelProperty(value = "创建时间")
    private String createTime;

    @ApiModelProperty(value = "开始时间", hidden = true)
    private String beginTime;

    @ApiModelProperty(value = "结束时间", hidden = true)
    private String endTime;

    @ApiModelProperty(value = "用户编号", hidden = true)
    private Long userNo;
}