package com.clx.performance.feign;

import com.clx.open.sdk.request.action.GetOrderBreakContractOwnerRuleFileAction;
import com.clx.open.sdk.request.dto.OrderCanExtractWeightDTO;
import com.clx.open.sdk.request.action.QueryPerformanceProgressAction;
import com.clx.open.sdk.request.action.QueryPerformanceProgressLogAction;
import com.clx.open.sdk.request.dto.OrderCanExtractWeightDTO;
import com.clx.open.sdk.request.dto.BatchOrderStatisticsInfoDTO;
import com.clx.open.sdk.request.dto.OwnerCancelResidueWeightDTO;
import com.clx.performance.param.pc.OrderCancelParam;
import com.clx.performance.vo.pc.OwnerAccountAllVO;
import com.clx.performance.vo.pc.PerformanceProgressOperationLogVO;
import com.clx.performance.vo.pc.PerformanceProgressVO;
import com.clx.performance.vo.pc.breakcontract.carrier.BreakContractOwnerRuleFileVO;
import com.msl.common.result.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.constraints.NotEmpty;
import java.math.BigDecimal;
import java.util.List;

@FeignClient(name = "clx-performance", configuration = PerformanceClientConfiguration.class)
public interface PerformanceSDKFeign {


    @PostMapping(value = {"clx-performance/feign/sdk/ownCancelOrderPre"})
    Result<Integer> ownCancelOrderPre(@RequestBody OrderCancelParam param);


    @GetMapping(value = {"clx-performance/feign/sdk/orderCancelResidueWeight"})
    Result<OwnerCancelResidueWeightDTO> orderCancelResidueWeight(@RequestParam(value = "orderNo") String orderNo, @RequestParam(value = "optionType") String optionType);


    @GetMapping(value = {"clx-performance/feign/sdk/accountAllInfo"})
    Result<OwnerAccountAllVO> accountAllInfo(@RequestParam Long userNo);

    /**
     * 查询规则文档信息
     */
    @PostMapping("clx-performance/feign/sdk/getOwnerRuleFile")
    Result<BreakContractOwnerRuleFileVO> getOwnerRuleFile(@RequestBody GetOrderBreakContractOwnerRuleFileAction action);

    @GetMapping("clx-performance/feign/sdk/queryPerformanceProgress")
    Result<List<PerformanceProgressVO>> queryPerformanceProgress(@RequestBody QueryPerformanceProgressAction action);

    @GetMapping("clx-performance/feign/sdk/queryPerformanceProgressLog")
    Result<List<PerformanceProgressOperationLogVO>> queryPerformanceProgressLog(@RequestBody QueryPerformanceProgressLogAction action);



    @GetMapping(value = {"clx-performance/feign/sdk/getOrderCanExtractWeight"})
    Result<OrderCanExtractWeightDTO> getOrderCanExtractWeight(@RequestParam(value = "orderNo") String orderNo);



    @GetMapping("clx-performance/feign/sdk/queryTaskStatisticsInfo")
    Result<BatchOrderStatisticsInfoDTO> queryTaskStatisticsInfo(@RequestParam("orderNoList")
    @NotEmpty(message = "订单编号集合不能为空") List<String> orderNoList);



    @GetMapping(value = {"clx-performance/feign/sdk/getOrderResidueWeight"})
    Result<BigDecimal> getOrderResidueWeight(@RequestParam(value = "orderNo") String orderNo);
}
