/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.der.util;

import cn.com.infosec.netsign.der.util.DERUtil;
import cn.com.infosec.netsign.der.util.Extension;
import java.io.IOException;
import java.util.ArrayList;
import javax.security.auth.x500.X500Principal;

public class DERObjectGenerater {
    public static final byte[] OID_PKCS7_DATA = new byte[]{6, 9, 42, -122, 72, -122, -9, 13, 1, 7, 1};
    public static final byte[] OID_PKCS7_SIGNEDDATA = new byte[]{6, 9, 42, -122, 72, -122, -9, 13, 1, 7, 2};
    public static final byte[] OID_PKCS7_ENVELOPEDDATA = new byte[]{6, 9, 42, -122, 72, -122, -9, 13, 1, 7, 3};
    public static final byte[] OID_PKCS7_SIGNEDANDENVELOPEDDATA = new byte[]{6, 9, 42, -122, 72, -122, -9, 13, 1, 7, 4};
    public static final byte[] OID_PKCS7_DIGESTEDDATA = new byte[]{6, 9, 42, -122, 72, -122, -9, 13, 1, 7, 5};
    public static final byte[] OID_PKCS7_ENCRYPTEDDATA = new byte[]{6, 9, 42, -122, 72, -122, -9, 13, 1, 7, 6};

    public byte[] generateExtensions(ArrayList extensions) {
        byte[] es = new byte[]{};
        int i = 0;
        int size = extensions.size();
        while (i < size) {
            byte[] e = this.generateExtension((Extension)extensions.get(i));
            es = DERUtil.connect(es, e);
            ++i;
        }
        es = DERUtil.generateDERCode(48, es);
        return DERUtil.generateDERCode(163, es);
    }

    private byte[] generateExtension(Extension e) {
        byte[] all = DERUtil.oid2ASN1(e.getOid());
        all = DERUtil.generateDERCode(6, all);
        if (e.isCritical()) {
            all = DERUtil.connect(all, DERUtil.DERTRUE);
        }
        all = DERUtil.connect(all, e.getValue());
        return DERUtil.generateDERCode(48, all);
    }

    public byte[] generateAlgorithmIdentifier(String oidstr) {
        if (oidstr == null) {
            return null;
        }
        byte[] oid = DERUtil.oid2ASN1(oidstr);
        oid = DERUtil.generateDERCode(6, oid);
        byte[] alg = DERUtil.connect(oid, DERUtil.DERNULL);
        return DERUtil.generateDERCode(48, alg);
    }

    public byte[] generateDN(String dn) throws IOException {
        X500Principal name = new X500Principal(dn);
        return name.getEncoded();
    }
}

