/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.agent.newcommunitor;

import cn.com.infosec.netsign.agent.exception.NetSignAgentException;
import cn.com.infosec.netsign.agent.logger.ConnectionLogger;
import cn.com.infosec.netsign.agent.newcommunitor.AgentCommunitor;
import cn.com.infosec.netsign.agent.service.NSPSService;
import cn.com.infosec.netsign.agent.service.NSService;
import cn.com.infosec.netsign.agent.service.ServiceSelector;
import cn.com.infosec.netsign.base.NSMessage;
import cn.com.infosec.netsign.base.NSMessageOpt;
import cn.com.infosec.netsign.communication.Communicator;
import cn.com.infosec.netsign.communication.multiple.MultiCommunicator;
import java.io.IOException;
import java.net.BindException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;

public class ThinCommunitor
implements AgentCommunitor {
    private NSService s;
    private Communicator conn;
    public static final String SOCKET_CLOSED = "Socket is closed";
    public static final String CONNECTION_RESET = "Connection reset";
    public static final String SOCKET_WRITE_ERROR = "Connect reset by peer:Socket write error";
    public static final String SOCKET_BROKEN_PIPE = "Broken pipe";
    public static final String TOO_MANY_OPEN_FILE = "Too many open files";

    public ThinCommunitor(NSService s) throws NetSignAgentException {
        this.s = s;
        ConnectionLogger.log(new String[]{"$TNAME", ": NetSignAgent connecting to ", "$SERVICE", "."}, s);
        try {
            this.openConnection();
        }
        catch (Exception e) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.openConnection();
        }
    }

    public ThinCommunitor() {
    }

    public static void createThinCommunitor(ServiceSelector selector, ThinCommunitor tc) throws NetSignAgentException {
        NSService s = null;
        NetSignAgentException exception = null;
        while ((s = selector.nextService()) != null) {
            try {
                tc.setService(s);
                return;
            }
            catch (NetSignAgentException e) {
                e.printStackTrace(System.out);
                ConnectionLogger.logForce(new String[]{"$TNAME", ": NetSignAgent connect to ", "$SERVICE", " failed caused by [", e.toString(), "]."}, s);
                exception = e;
            }
        }
        if (exception != null) {
            throw exception;
        }
        throw new NetSignAgentException(-1006, "all service are inavailable");
    }

    public NSService getService() {
        return this.s;
    }

    public void setService(NSService s) throws NetSignAgentException {
        this.s = s;
        ConnectionLogger.log(new String[]{"$TNAME", ": NetSignAgent connecting to ", "$SERVICE", "."}, s);
        try {
            this.openConnection();
        }
        catch (Exception e) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.openConnection();
        }
    }

    private void setPassword(NSMessage msg, NSService s) {
        if (s instanceof NSPSService) {
            NSPSService pss = (NSPSService)s;
            msg.setApiPasswd(pss.getApiPasswd());
        }
    }

    public synchronized NSMessageOpt sendMessage(NSMessage msg) throws NetSignAgentException {
        this.s.setLastTestTime(System.currentTimeMillis());
        this.setPassword(msg, this.s);
        NSMessageOpt res = null;
        try {
            this.conn.send(msg);
        }
        catch (SocketException skEx) {
            this.s.setStatus(false);
            ConnectionLogger.logForce(new String[]{"$TNAME", ": NetSignAgent connect to ", "$SERVICE", " failed caused by [", skEx.toString(), "]."}, this.s);
            if (SOCKET_CLOSED.equalsIgnoreCase(skEx.getMessage())) {
                throw new NetSignAgentException(-10061001, skEx.getMessage());
            }
            if (CONNECTION_RESET.equalsIgnoreCase(skEx.getMessage())) {
                throw new NetSignAgentException(-10061002, skEx.getMessage());
            }
            if (SOCKET_WRITE_ERROR.equalsIgnoreCase(skEx.getMessage())) {
                throw new NetSignAgentException(-10061003, skEx.getMessage());
            }
            if (SOCKET_BROKEN_PIPE.equalsIgnoreCase(skEx.getMessage())) {
                throw new NetSignAgentException(-10061004, skEx.getMessage());
            }
            if (TOO_MANY_OPEN_FILE.equalsIgnoreCase(skEx.getMessage())) {
                throw new NetSignAgentException(-10061005, skEx.getMessage());
            }
            throw new NetSignAgentException(-1003, skEx.getMessage());
        }
        catch (SocketTimeoutException stEx) {
            this.s.setStatus(false);
            ConnectionLogger.logForce(new String[]{"$TNAME", ": NetSignAgent connect to ", "$SERVICE", " failed caused by [", stEx.toString(), "]."}, this.s);
            throw new NetSignAgentException(-10061006, stEx.getMessage());
        }
        catch (IOException ioEx) {
            this.s.setStatus(false);
            ConnectionLogger.logForce(new String[]{"$TNAME", ": NetSignAgent connect to ", "$SERVICE", " failed caused by [", ioEx.toString(), "]."}, this.s);
            throw new NetSignAgentException(-1003, ioEx.getMessage());
        }
        catch (Exception ex) {
            this.s.setStatus(false);
            ConnectionLogger.logForce(new String[]{"$TNAME", ": NetSignAgent connect to ", "$SERVICE", " failed caused by [", ex.toString(), "]."}, this.s);
            throw new NetSignAgentException(-1003, ex.getMessage());
        }
        try {
            res = (NSMessageOpt)this.conn.recv();
        }
        catch (SocketException skEx) {
            this.s.setStatus(false);
            ConnectionLogger.logForce(new String[]{"$TNAME", ": NetSignAgent receive message failed from ", "$SERVICE", " caused by [", skEx.toString(), "]."}, this.s);
            if (SOCKET_CLOSED.equalsIgnoreCase(skEx.getMessage())) {
                throw new NetSignAgentException(-10062001, skEx.getMessage());
            }
            if (CONNECTION_RESET.equalsIgnoreCase(skEx.getMessage())) {
                throw new NetSignAgentException(-10062002, skEx.getMessage());
            }
            if (SOCKET_WRITE_ERROR.equalsIgnoreCase(skEx.getMessage())) {
                throw new NetSignAgentException(-10062003, skEx.getMessage());
            }
            if (SOCKET_BROKEN_PIPE.equalsIgnoreCase(skEx.getMessage())) {
                throw new NetSignAgentException(-10062004, skEx.getMessage());
            }
            if (TOO_MANY_OPEN_FILE.equalsIgnoreCase(skEx.getMessage())) {
                throw new NetSignAgentException(-10062005, skEx.getMessage());
            }
            throw new NetSignAgentException(-1004, skEx.getMessage());
        }
        catch (SocketTimeoutException stEx) {
            this.s.setStatus(false);
            ConnectionLogger.logForce(new String[]{"$TNAME", ": NetSignAgent receive message failed from ", "$SERVICE", " caused by [", stEx.toString(), "]."}, this.s);
            throw new NetSignAgentException(-10062006, stEx.getMessage());
        }
        catch (IOException ioEx) {
            this.s.setStatus(false);
            ConnectionLogger.logForce(new String[]{"$TNAME", ": NetSignAgent receive message failed from ", "$SERVICE", " caused by [", ioEx.toString(), "]."}, this.s);
            throw new NetSignAgentException(-1004, ioEx.getMessage());
        }
        catch (ClassNotFoundException clsEx) {
            throw new NetSignAgentException(-1005, clsEx.getMessage());
        }
        catch (Exception ex) {
            this.s.setStatus(false);
            ConnectionLogger.logForce(new String[]{"$TNAME", ": NetSignAgent receive message failed from ", "$SERVICE", " caused by [", ex.toString(), "]."}, this.s);
            throw new NetSignAgentException(-1004, ex.getMessage());
        }
        String notice = res.getNotice();
        this.s.setStatus(true);
        return res;
    }

    public void openConnection() throws NetSignAgentException {
        this.s.addConnCount();
        try {
            InetSocketAddress isa = new InetSocketAddress(this.s.getIp(), this.s.getPort());
            Socket socket = new Socket();
            socket.setSoTimeout(this.s.getTimeout());
            socket.setTcpNoDelay(true);
            socket.setSoLinger(true, 0);
            socket.connect(isa, this.s.getTimeout());
            this.conn = new MultiCommunicator(socket);
            ConnectionLogger.log(new String[]{"$TNAME", ": NetSignAgent connecting to ", "$SERVICE", " successed."}, this.s);
        }
        catch (BindException bindEx) {
            this.s.reduceConnCount();
            this.s.setLastTestTime(System.currentTimeMillis());
            this.s.setStatus(false);
            try {
                this.conn.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ConnectionLogger.logForce(new String[]{"$TNAME", ": NetSignAgent connect to ", "$SERVICE", " failed caused by [", bindEx.toString(), "]."}, this.s);
            throw new NetSignAgentException(-10063001, bindEx.getMessage());
        }
        catch (ConnectException cntEx) {
            this.s.reduceConnCount();
            this.s.setLastTestTime(System.currentTimeMillis());
            this.s.setStatus(false);
            try {
                this.conn.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ConnectionLogger.logForce(new String[]{"$TNAME", ": NetSignAgent connect to ", "$SERVICE", " failed caused by [", cntEx.toString(), "]."}, this.s);
            throw new NetSignAgentException(-10063002, cntEx.getMessage());
        }
        catch (SocketTimeoutException stEx) {
            this.s.reduceConnCount();
            this.s.setLastTestTime(System.currentTimeMillis());
            this.s.setStatus(false);
            try {
                this.conn.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ConnectionLogger.logForce(new String[]{"$TNAME", ": NetSignAgent connect to ", "$SERVICE", " failed caused by [", stEx.toString(), "]."}, this.s);
            throw new NetSignAgentException(-10063003, stEx.getMessage());
        }
        catch (Exception ioEx) {
            this.s.reduceConnCount();
            this.s.setLastTestTime(System.currentTimeMillis());
            this.s.setStatus(false);
            try {
                this.conn.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ConnectionLogger.logForce(new String[]{"$TNAME", ": NetSignAgent connect to ", "$SERVICE", " failed caused by [", ioEx.toString(), "]."}, this.s);
            if (ioEx instanceof UnknownHostException) {
                throw new NetSignAgentException(-1000, ioEx.getMessage());
            }
            throw new NetSignAgentException(-1001, ioEx.getMessage());
        }
    }

    public void close() {
        try {
            if (!this.conn.isClosed()) {
                this.s.reduceConnCount();
            }
            ConnectionLogger.log(new String[]{"$TNAME", ": NetSignAgent disconnect from ", "$SERVICE", "."}, this.s);
            if (this.conn != null) {
                this.conn.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

