/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.agent;

import cn.com.infosec.netsign.agent.NetSignAgentUtil;
import cn.com.infosec.netsign.agent.digest.SHA256Digest;
import cn.com.infosec.netsign.base.util.Utils;
import cn.com.infosec.netsign.crypto.util.Base64;
import cn.com.infosec.netsign.json.JsonObject;
import cn.com.infosec.netsign.json.JsonParser;
import cn.com.infosec.netsign.json.JsonValueArray;
import cn.com.infosec.netsign.json.JsonValueBoolean;
import cn.com.infosec.netsign.json.JsonValueDirect;
import cn.com.infosec.netsign.json.JsonValueNull;
import cn.com.infosec.netsign.json.JsonValueNumber;
import cn.com.infosec.netsign.json.JsonValueObject;
import cn.com.infosec.netsign.json.JsonValueString;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Arrays;
import java.util.Enumeration;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;

public class PBCAgent2GUtil {
    public static final String CUPSTC_JSONKEY_CERFILE = "cerFile";
    public static final String CUPSTC_JSONKEY_TXNTYPE = "txnType";
    public static final String CUPSTC_JSONKEY_SIGNATURE = "signature";
    public static final String CUPSTC_JSONKEY_ENCRYPTDATA = "encryptData";
    public static final String CUPSTC_JSONKEY_NEWKEY = "newKey";
    public static final String CUPSTC_JSONKEY_KEYTYPE = "keyTp";
    public static final String CUPSTC_JSONKEY_KEYLABEL = "keyLabel";
    public static final String CUPSTC_JSONKEY_IDCARDPICP = "idCardPicP";
    public static final String CUPSTC_JSONKEY_IDCARDPICN = "idCardPicN";
    public static final String CUPSTC_JSONKEY_RISKINFO = "riskInfo";
    public static final String CUPSTC_TXNTYPE_DOWNLOADCERT = "SA008";
    public static final String CUPSTC_TXNTYPE_RESETKEY = "SA009";
    public static final String CUPSTC_TXNTYPE_IMAGECOLLECTION = "SA029";
    public static final String CUPCQP_NOSIGN = "NoSign";
    public static final String CUPCQP_Encoding = "utf-8";
    public static final String CUPCQP_SIGN_MODEL = "SHA256";
    public static final String CUPCQP_SYMMENC_ALG = "DESede";
    public static final String CUPCQP_SYMMENC_MODEL = "/ECB/PKCS5Padding";
    public static final String CUPCQP_JSONKEY_CARDNO = "cardNo";
    public static final String CUPCQP_JSONKEY_MOBILE = "mobile";
    public static final String CUPCQP_JSONKEY_REALNM = "realNm";
    public static final String CUPCQP_JSONKEY_CERTIFID = "certifId";
    public static final String CUPCQP_JSONKEY_ACCTYPE = "accType";
    public static final String CUPCQP_JSONKEY_CERTTYPE = "certType";
    public static final String CUPCQP_JSONKEY_APPID = "appId";
    public static final String CUPCQP_JSONKEY_INDUSRID = "indUsrId";
    public static final String CUPCQP_JSONKEY_NONCESTR = "nonceStr";
    public static final String CUPCQP_JSONKEY_TIMESTAMP = "timestamp";
    public static final String CUPCQP_JSONKEY_CHNl = "chnl";
    public static final String CUPCQP_JSONKEY_SYMMETRICKEY = "symmetricKey";
    public static final String CUPCQP_JSONKEY_SIGNATURE = "signature";
    public static final String ENC_INFOSEC_ENCODING = "infosecEncoding";

    public static byte[] paddingText(byte[] plain, String padding, String alg) throws NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException {
        Cipher cipher;
        int blockSize;
        if (padding.toUpperCase().indexOf("NOPADDING") > -1 && (blockSize = (cipher = Cipher.getInstance(alg)).getBlockSize()) != 0 && plain.length % blockSize != 0) {
            byte[] tmp = new byte[plain.length / blockSize * blockSize + blockSize];
            System.arraycopy(plain, 0, tmp, 0, plain.length);
            plain = tmp;
        }
        return plain;
    }

    public static byte[] unPaddingText(byte[] plain, String padding, String alg) throws NoSuchAlgorithmException, NoSuchPaddingException {
        Cipher cipher;
        int blockSize;
        if (padding.toUpperCase().indexOf("NOPADDING") > -1 && (blockSize = (cipher = Cipher.getInstance(alg)).getBlockSize()) != 0) {
            int i = 0;
            while (i < blockSize) {
                if (plain[plain.length - 1 - i] != 0) break;
                ++i;
            }
            byte[] p1 = new byte[plain.length - i];
            System.arraycopy(plain, 0, p1, 0, p1.length);
            plain = p1;
        }
        return plain;
    }

    public static String symmEncryptLocal(String plain, byte[] key, String alg, String model) {
        byte[] result = null;
        try {
            result = NetSignAgentUtil.symmCipher(PBCAgent2GUtil.paddingText(plain.getBytes(CUPCQP_Encoding), model, alg), key, null, alg, model, 1);
        }
        catch (NoSuchAlgorithmException e2) {
            e2.printStackTrace();
        }
        catch (NoSuchPaddingException e2) {
            e2.printStackTrace();
        }
        catch (NoSuchProviderException e2) {
            e2.printStackTrace();
        }
        catch (UnsupportedEncodingException e2) {
            e2.printStackTrace();
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return null;
        }
        return Base64.encode(result);
    }

    public static String symmDecryptLocal(String plain, byte[] key, String alg, String model) {
        byte[] result = null;
        try {
            result = NetSignAgentUtil.symmCipher(Base64.decode(plain), key, null, alg, model, 2);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        try {
            return new String(PBCAgent2GUtil.unPaddingText(result, model, alg));
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (NoSuchPaddingException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String getValueByKey(JsonObject jsonObject, String key) {
        if (jsonObject == null || "".equals(key)) {
            return "";
        }
        if (jsonObject.getValue(key) instanceof JsonValueString) {
            return (String)((JsonValueString)jsonObject.getValue(key)).getValue();
        }
        if (jsonObject.getValue(key) instanceof JsonValueObject) {
            return (String)((JsonValueObject)jsonObject.getValue(key)).getValue();
        }
        if (jsonObject.getValue(key) instanceof JsonValueArray) {
            return (String)((JsonValueArray)jsonObject.getValue(key)).getValue();
        }
        if (jsonObject.getValue(key) instanceof JsonValueBoolean) {
            return (String)((JsonValueBoolean)jsonObject.getValue(key)).getValue();
        }
        if (jsonObject.getValue(key) instanceof JsonValueDirect) {
            return (String)((JsonValueDirect)jsonObject.getValue(key)).getValue();
        }
        if (jsonObject.getValue(key) instanceof JsonValueNull) {
            return (String)((JsonValueNull)jsonObject.getValue(key)).getValue();
        }
        if (jsonObject.getValue(key) instanceof JsonValueNumber) {
            return (String)((JsonValueNumber)jsonObject.getValue(key)).getValue();
        }
        return "";
    }

    public static String getCUPCQSignString(JsonObject jsonObject) {
        StringBuffer signStr = new StringBuffer();
        int i = 0;
        int j = 0;
        int k = 0;
        Enumeration names = jsonObject.getNames();
        while (names.hasMoreElements()) {
            names.nextElement();
            ++i;
        }
        Object[] ss = new String[i];
        Enumeration namess = jsonObject.getNames();
        while (namess.hasMoreElements()) {
            ss[j++] = (String)namess.nextElement();
        }
        Arrays.sort(ss);
        while (k < i) {
            if (CUPCQP_JSONKEY_SYMMETRICKEY.toUpperCase().equals(((String)ss[k]).toUpperCase()) || "signature".toUpperCase().equals(((String)ss[k]).toUpperCase()) || ENC_INFOSEC_ENCODING.toUpperCase().equals(((String)ss[k]).toUpperCase())) {
                ++k;
                continue;
            }
            String str = PBCAgent2GUtil.getValueByKey(jsonObject, (String)ss[k]);
            if (PBCAgent2GUtil.notEmpty(str)) {
                signStr.append((String)ss[k]).append("=").append(str).append("&");
            }
            ++k;
        }
        String result = signStr.toString();
        return result.substring(0, result.length() - 1);
    }

    public static String getCUPSTCSignString(JsonObject jsonObject) {
        StringBuffer sign = new StringBuffer();
        int i = 0;
        int j = 0;
        int k = 0;
        Enumeration names = jsonObject.getNames();
        while (names.hasMoreElements()) {
            names.nextElement();
            ++i;
        }
        Object[] ss = new String[i];
        Enumeration namess = jsonObject.getNames();
        while (namess.hasMoreElements()) {
            ss[j++] = (String)namess.nextElement();
        }
        Arrays.sort(ss);
        while (k < i) {
            Object key = ss[k];
            if ("signature".toUpperCase().equals(((String)key).toUpperCase())) {
                ++k;
                continue;
            }
            String value = PBCAgent2GUtil.getValueByKey(jsonObject, (String)key);
            if (PBCAgent2GUtil.notEmpty(value)) {
                if (CUPSTC_JSONKEY_IDCARDPICN.equals(key) || CUPSTC_JSONKEY_IDCARDPICP.equals(key)) {
                    byte[] digest = new byte[32];
                    byte[] plain = value.getBytes();
                    SHA256Digest sha256Digest = new SHA256Digest();
                    sha256Digest.update(plain, 0, plain.length);
                    sha256Digest.doFinal(digest, 0);
                    value = Utils.toHexString(digest).toUpperCase();
                }
                sign.append((String)key).append("=").append(value).append("&");
            }
            ++k;
        }
        return sign.toString();
    }

    public static void putStringToJson(JsonObject jsonObject, String key, String value) {
        JsonValueString j = new JsonValueString();
        j.setValue(value);
        jsonObject.put(key, j);
    }

    public static void putObjectToJson(JsonObject jsonObject, String key, String value, JsonParser parser) {
        JsonValueObject j = new JsonValueObject();
        j.setValue(parser.parse(value.toCharArray()));
        jsonObject.put(key, j);
    }

    public static boolean notEmpty(Object obj) {
        return obj != null && !"".equals(obj);
    }

    public static boolean empty(Object obj) {
        return obj == null || "".equals(obj);
    }
}

