/*
 * Decompiled with CFR 0.152.
 */
package com.nbcb.sdk.aes.service;

import com.nbcb.sdk.AbstractBussinessBean;
import com.nbcb.sdk.SDKRequestHead;
import com.nbcb.sdk.aes.param.ConfigFile;
import com.nbcb.sdk.aes.utils.DateUtil;
import com.nbcb.sdk.aes.utils.JsonUtils;
import com.nbcb.sdk.aes.utils.LocalAddressUtil;
import com.nbcb.sdk.aes.utils.RandomKey;
import java.util.Map;
import java.util.UUID;

public class PackHeadService {
    public static SDKRequestHead packReqHeadByBean(AbstractBussinessBean bean, String token) throws Exception {
        SDKRequestHead head = null;
        head = null == bean ? new SDKRequestHead() : bean.getRequestHead();
        head.setAPP_Key(ConfigFile.APPKEY);
        head.setRndm_Num(new String(RandomKey.getKey(16)));
        head.setAPP_Token(token);
        head.setMAC_Adr(LocalAddressUtil.getMacAddress());
        head.setIP_Adr(LocalAddressUtil.getIpAddress());
        head.setTxn_ModDsc("java");
        head.setSDK_VNo("2.1.230630");
        head.setSDK_Sgn("");
        String[] date = DateUtil.getDateTime();
        head.setRqs_Dt(date[0]);
        head.setRqs_Tm(date[1]);
        head.setRqs_Jrnl_No(UUID.randomUUID().toString());
        head.setMer_Name(ConfigFile.MERNAME);
        head.setSub_Mer_Name(ConfigFile.SUBMERNAME);
        head.setSub_Mer_ID(ConfigFile.SUBMERID);
        return head;
    }

    public static SDKRequestHead packReqHeadByJson(String productID, String json, String token) throws Exception {
        SDKRequestHead head = new SDKRequestHead();
        Map<String, String> reqMap = JsonUtils.getMapObj(json);
        String headStr = reqMap.get("Head");
        Map<String, String> headMap = JsonUtils.getMapObj(headStr);
        if (null != headMap) {
            head.setAPI_VNo(headMap.get("API_VNo"));
            head.setPD_VNo(headMap.get("PD_VNo"));
        }
        head.setAPP_Key(ConfigFile.APPKEY);
        head.setRndm_Num(new String(RandomKey.getKey(16)));
        head.setAPP_Token(token);
        head.setMAC_Adr(LocalAddressUtil.getMacAddress());
        head.setIP_Adr(LocalAddressUtil.getIpAddress());
        head.setTxn_ModDsc("java");
        head.setSDK_VNo("2.1.230630");
        head.setSDK_Sgn("");
        String[] date = DateUtil.getDateTime();
        head.setRqs_Dt(date[0]);
        head.setRqs_Tm(date[1]);
        head.setRqs_Jrnl_No(UUID.randomUUID().toString());
        head.setMer_Name(ConfigFile.MERNAME);
        head.setSub_Mer_Name(ConfigFile.SUBMERNAME);
        head.setSub_Mer_ID(ConfigFile.SUBMERID);
        return head;
    }

    public static SDKRequestHead packReqHeadByBean(String appkey, AbstractBussinessBean bean, String token) throws Exception {
        SDKRequestHead head = null;
        head = null == bean ? new SDKRequestHead() : bean.getRequestHead();
        head.setAPP_Key(ConfigFile.configMap.get(appkey).getAPPKEY());
        head.setRndm_Num(new String(RandomKey.getKey(16)));
        head.setAPP_Token(token);
        head.setMAC_Adr(LocalAddressUtil.getMacAddress());
        head.setIP_Adr(LocalAddressUtil.getIpAddress());
        head.setTxn_ModDsc("java");
        head.setSDK_VNo("2.1.230630");
        head.setSDK_Sgn("");
        String[] date = DateUtil.getDateTime();
        head.setRqs_Dt(date[0]);
        head.setRqs_Tm(date[1]);
        head.setRqs_Jrnl_No(UUID.randomUUID().toString());
        head.setMer_Name(ConfigFile.MERNAME);
        head.setSub_Mer_Name(ConfigFile.SUBMERNAME);
        head.setSub_Mer_ID(ConfigFile.SUBMERID);
        return head;
    }

    public static SDKRequestHead packReqHeadByJson(String appkey, String productID, String json, String token) throws Exception {
        SDKRequestHead head = new SDKRequestHead();
        Map<String, String> reqMap = JsonUtils.getMapObj(json);
        String headStr = reqMap.get("Head");
        Map<String, String> headMap = JsonUtils.getMapObj(headStr);
        if (null != headMap) {
            head.setAPI_VNo(headMap.get("API_VNo"));
            head.setPD_VNo(headMap.get("PD_VNo"));
        }
        head.setAPP_Key(appkey);
        head.setRndm_Num(new String(RandomKey.getKey(16)));
        head.setAPP_Token(token);
        head.setMAC_Adr(LocalAddressUtil.getMacAddress());
        head.setIP_Adr(LocalAddressUtil.getIpAddress());
        head.setTxn_ModDsc("java");
        head.setSDK_VNo("2.1.230630");
        head.setSDK_Sgn("");
        String[] date = DateUtil.getDateTime();
        head.setRqs_Dt(date[0]);
        head.setRqs_Tm(date[1]);
        head.setRqs_Jrnl_No(UUID.randomUUID().toString());
        head.setMer_Name(ConfigFile.MERNAME);
        head.setSub_Mer_Name(ConfigFile.SUBMERNAME);
        head.setSub_Mer_ID(ConfigFile.SUBMERID);
        return head;
    }
}

