/*
 * Decompiled with CFR 0.152.
 */
package com.nbcb.bouncycastle.asn1;

import com.nbcb.bouncycastle.asn1.ASN1Integer;
import com.nbcb.bouncycastle.asn1.ASN1OctetString;
import com.nbcb.bouncycastle.asn1.ASN1OutputStream;
import com.nbcb.bouncycastle.asn1.ASN1Primitive;
import com.nbcb.bouncycastle.asn1.ASN1TaggedObject;
import com.nbcb.bouncycastle.asn1.StreamUtil;
import com.nbcb.bouncycastle.util.Arrays;
import com.nbcb.bouncycastle.util.Properties;
import java.io.IOException;
import java.math.BigInteger;

public class ASN1Enumerated
extends ASN1Primitive {
    private final byte[] bytes;
    private static ASN1Enumerated[] cache = new ASN1Enumerated[12];

    public static ASN1Enumerated getInstance(Object obj) {
        if (obj == null || obj instanceof ASN1Enumerated) {
            return (ASN1Enumerated)obj;
        }
        if (obj instanceof byte[]) {
            try {
                return (ASN1Enumerated)ASN1Enumerated.fromByteArray((byte[])obj);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("encoding error in getInstance: " + e.toString());
            }
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static ASN1Enumerated getInstance(ASN1TaggedObject obj, boolean explicit) {
        ASN1Primitive o = obj.getObject();
        if (explicit || o instanceof ASN1Enumerated) {
            return ASN1Enumerated.getInstance(o);
        }
        return ASN1Enumerated.fromOctetString(((ASN1OctetString)o).getOctets());
    }

    public ASN1Enumerated(int value) {
        this.bytes = BigInteger.valueOf(value).toByteArray();
    }

    public ASN1Enumerated(BigInteger value) {
        this.bytes = value.toByteArray();
    }

    public ASN1Enumerated(byte[] bytes) {
        if (!Properties.isOverrideSet("com.nbcb.bouncycastle.asn1.allow_unsafe_integer") && ASN1Integer.isMalformed(bytes)) {
            throw new IllegalArgumentException("malformed enumerated");
        }
        this.bytes = Arrays.clone(bytes);
    }

    public BigInteger getValue() {
        return new BigInteger(this.bytes);
    }

    @Override
    boolean isConstructed() {
        return false;
    }

    @Override
    int encodedLength() {
        return 1 + StreamUtil.calculateBodyLength(this.bytes.length) + this.bytes.length;
    }

    @Override
    void encode(ASN1OutputStream out) throws IOException {
        out.writeEncoded(10, this.bytes);
    }

    @Override
    boolean asn1Equals(ASN1Primitive o) {
        if (!(o instanceof ASN1Enumerated)) {
            return false;
        }
        ASN1Enumerated other = (ASN1Enumerated)o;
        return Arrays.areEqual(this.bytes, other.bytes);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.bytes);
    }

    static ASN1Enumerated fromOctetString(byte[] enc) {
        if (enc.length > 1) {
            return new ASN1Enumerated(enc);
        }
        if (enc.length == 0) {
            throw new IllegalArgumentException("ENUMERATED has zero length");
        }
        int value = enc[0] & 0xFF;
        if (value >= cache.length) {
            return new ASN1Enumerated(Arrays.clone(enc));
        }
        ASN1Enumerated possibleMatch = cache[value];
        if (possibleMatch == null) {
            possibleMatch = ASN1Enumerated.cache[value] = new ASN1Enumerated(Arrays.clone(enc));
        }
        return possibleMatch;
    }
}

