package com.clx.performance.service.customer.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.dao.customer.CustomerComplaintDetailDao;
import com.clx.performance.model.customer.CustomerComplaintDetail;
import com.clx.performance.param.pc.customer.PageCustomerComplaintDetailParam;
import com.clx.performance.param.pc.customer.SaveCustomerComplaintDetailParam;
import com.clx.performance.service.customer.CustomerComplaintDetailService;
import com.clx.performance.struct.customer.CustomerComplaintDetailStruct;
import com.clx.performance.vo.pc.customer.CustomerComplaintDetailVO;
import com.msl.user.data.UserSessionData;
import com.msl.user.utils.TokenUtil;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.Arrays;

/**
 * @ClassName CustomerComplaintTypeServiceImpl
 * @Description
 * @Author kavin
 * @Date 2023/12/7 10:51
 * @Version 1.0
 */
@Slf4j
@Service
@AllArgsConstructor
public class CustomerComplaintDetailServiceImpl implements CustomerComplaintDetailService {
    private final CustomerComplaintDetailDao customerComplaintDetailDao;
    private final CustomerComplaintDetailStruct customerComplaintDetailStruct;
    @Override
    public void saveCustomerComplaintDetail(SaveCustomerComplaintDetailParam param) {
        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();
        CustomerComplaintDetail detail = new CustomerComplaintDetail();
        detail.setDriverUserNo(loginUserInfo.getUserNo());
        detail.setDriverName(loginUserInfo.getUserName());
        detail.setDriverMobile(loginUserInfo.getUserMobile());
        detail.setChildNo(param.getChildNo());
        detail.setComplaintTypeId(param.getComplaintTypeId());
        detail.setContent(param.getContent());
        if(CollectionUtil.isNotEmpty(param.getPicture())){
            detail.setPicture(String.join(",",param.getPicture()));
        }
        customerComplaintDetailDao.saveEntity(detail);
    }

    @Override
    public IPage<CustomerComplaintDetailVO> pageCustomerComplaintDetail(PageCustomerComplaintDetailParam param) {
        Page<CustomerComplaintDetailVO> page  = customerComplaintDetailDao.pageCustomerComplaintDetail(param);
        if(CollectionUtil.isNotEmpty(page.getRecords())){
            page.getRecords().forEach(item->{
                if(StringUtils.isNotBlank(item.getPicture())){
                    item.setPictureList(Arrays.asList(item.getPicture().split(",")));
                }
            });
        }
        return page;
    }
}
