package com.clx.performance.dao.impl.loan;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.dao.loan.OwnerPaymentDao;
import com.clx.performance.mapper.loan.OwnerPaymentMapper;
import com.clx.performance.model.loan.OwnerPayment;
import com.clx.performance.param.pc.loan.carrier.PageCarrierOwnerPaymentParam;
import com.msl.common.dao.impl.BaseDaoImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Objects;

/**
 * @author kavin
 * Date 2024-01-20
 * Time 13:31
 */
@Repository
public class OwnerPaymentDaoImpl extends BaseDaoImpl<OwnerPaymentMapper, OwnerPayment, Integer> implements OwnerPaymentDao {

    @Override
    public IPage<OwnerPayment> pageOwnerPayment(PageCarrierOwnerPaymentParam param) {

        LambdaQueryWrapper<OwnerPayment> query = new LambdaQueryWrapper<>();
        if(Objects.nonNull(param.getRepaymentNo())){
            query.eq(OwnerPayment :: getRepaymentNo,param.getRepaymentNo());
        }
        if(StringUtils.isNotBlank(param.getOwnerUserNo())){
            query.eq(OwnerPayment :: getOwnerUserNo,param.getOwnerUserNo());
        }
        if(StringUtils.isNotBlank(param.getOwnerUserName())){
            query.like(OwnerPayment :: getOwnerUserName,param.getOwnerUserName());
        }
        if(StringUtils.isNotBlank(param.getMobile())){
            query.like(OwnerPayment :: getMobile,param.getMobile());
        }
        if(Objects.nonNull(param.getPaymentNo())){
            query.like(OwnerPayment :: getPaymentNo,param.getPaymentNo());
        }
        if(Objects.nonNull(param.getStatus())){
            query.like(OwnerPayment :: getStatus,param.getStatus());
        }
        query.orderByDesc(OwnerPayment :: getCreateTime);
        return baseMapper.selectPage(Page.of(param.getPage(), param.getPageSize()),query);
    }

    @Override
    public void updateStatusAndMerchantRunningWaterNo(OwnerPayment ownerPayment) {
        update(lUdWrapper().set(OwnerPayment::getStatus, ownerPayment.getStatus())
                .set(OwnerPayment::getMerchantRunningWaterNo, ownerPayment.getMerchantRunningWaterNo())
                .eq(OwnerPayment::getId, ownerPayment.getId())
        );
    }

    @Override
    public List<OwnerPayment> selectListByPayStatus(Integer status) {
        return list(lQrWrapper().eq(OwnerPayment::getStatus, status));
    }

    @Override
    public void updatePayStatus(Integer id, Integer status) {
        update(lUdWrapper().set(OwnerPayment::getStatus, status)
                .eq(OwnerPayment::getId, id)
        );
    }
}
