package com.clx.performance.enums.loan;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

public enum BankTradeEnum {
    ;

    @Getter
    @AllArgsConstructor
    public enum TradeType {
        ORDER_DIRECT_PAY(3, "订单支付"),
        ORDER_TRANSFER_PAY(2, "转账支付"),
        ;

        private final Integer code;
        private final String msg;

        public static Optional<TradeType> getByCode(Integer code) {
            return Arrays.stream(values()).filter(e -> Objects.equals(e.code , code)).findFirst();
        }

        public static String getMsgByCode(Integer code) {
            return getByCode(code).map(TradeType::getMsg).orElse(null);
        }
    }

    @Getter
    @AllArgsConstructor
    public enum OrderType {
        OWNER_LOAN_RECORD(1, "货主借款"),

        ;

        private final Integer code;
        private final String msg;

        public static Optional<OrderType> getByCode(Integer code) {
            return Arrays.stream(values()).filter(e -> Objects.equals(e.code , code)).findFirst();
        }

        public static String getMsgByCode(Integer code) {
            return getByCode(code).map(OrderType::getMsg).orElse(null);
        }
    }

}
