package com.clx.performance.struct.breakcontract;

import com.clx.performance.enums.BreakContractSettlementDriverEnum;
import com.clx.performance.enums.BreakContractSettlementOwnerEnum;
import com.clx.performance.model.breakcontract.BreakContractSettlementOwner;
import com.clx.performance.vo.pc.breakcontract.carrier.CarrierBreakContractSettlementOwnerDetailVO;
import com.clx.performance.vo.pc.breakcontract.carrier.PageCarrierBreakContractSettlementOwnerVO;
import com.msl.common.utils.DateStructUtil;
import com.msl.common.utils.DateUtils;
import org.mapstruct.IterableMapping;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Named;

import java.util.List;

@Mapper(componentModel = "spring", uses = DateStructUtil.class, imports = {BreakContractSettlementDriverEnum.class, BreakContractSettlementOwnerEnum.class,  DateUtils.class})
public interface BreakContractSettlementOwnerStruct {


    @Named("toBaseVo")
    @Mapping(target = "breakContractPartyTypeMsg", expression = "java(BreakContractSettlementDriverEnum.BreachContractPartyType.getMsgByCode(detail.getBreakContractPartyType()))")
    @Mapping(target = "statusMsg", expression = "java(BreakContractSettlementOwnerEnum.Status.getMsgByCode(detail.getStatus()))")
    PageCarrierBreakContractSettlementOwnerVO convert(BreakContractSettlementOwner detail);

    @IterableMapping(qualifiedByName = "toBaseVo")
    List<PageCarrierBreakContractSettlementOwnerVO> covertToCarrierList(List<BreakContractSettlementOwner> list);

    @Mapping(target = "breakContractPartyTypeMsg", expression = "java(BreakContractSettlementDriverEnum.BreachContractPartyType.getMsgByCode(settlementOwner.getBreakContractPartyType()))")
    @Mapping(target = "statusMsg", expression = "java(BreakContractSettlementOwnerEnum.Status.getMsgByCode(settlementOwner.getStatus()))")
    CarrierBreakContractSettlementOwnerDetailVO convertToDetail(BreakContractSettlementOwner settlementOwner);


}
