package com.clx.performance.struct.breakcontract;

import com.clx.performance.enums.BreakContractOwnerRecordEnum;
import com.clx.performance.model.breakcontract.BreakContractOwnerRecord;
import com.clx.performance.vo.pc.breakcontract.owner.PageOwnerBreakContractOwnerRecordVO;
import com.msl.common.utils.DateStructUtil;
import com.msl.common.utils.DateUtils;
import org.mapstruct.IterableMapping;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Named;

import java.util.List;

@Mapper(componentModel = "spring", uses = DateStructUtil.class, imports = {BreakContractOwnerRecordEnum.class,  DateUtils.class})
public interface BreakContractOwnerRecordStruct {


    @Named("toBaseVo")
    @Mapping(target = "payStatusMsg", expression = "java(BreakContractOwnerRecordEnum.PayStatus.getMsgByCode(detail.getPayStatus()))")
    PageOwnerBreakContractOwnerRecordVO convert(BreakContractOwnerRecord detail);

    @IterableMapping(qualifiedByName = "toBaseVo")
    List<PageOwnerBreakContractOwnerRecordVO> covertToOwnerList(List<BreakContractOwnerRecord> list);




}
