package com.clx.performance.service.impl.breakcontract;


import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.dao.breakcontract.BreakContractOwnerRuleDao;
import com.clx.performance.enums.PerformanceResultEnum;
import com.clx.performance.model.breakcontract.BreakContractOwnerRule;
import com.clx.performance.param.pc.breakcontract.carrier.BreakContractOwnerRuleAddParam;
import com.clx.performance.param.pc.breakcontract.carrier.BreakContractOwnerRuleStatusUpdateParam;
import com.clx.performance.param.pc.breakcontract.carrier.PageBreakContractOwnerRuleParam;
import com.clx.performance.service.breakcontract.BreakContractOwnerRuleService;
import com.clx.performance.struct.breakcontract.BreakContractOwnerRuleStruct;
import com.clx.performance.vo.pc.breakcontract.carrier.BreakContractOwnerRuleVO;
import com.msl.common.exception.ServiceSystemException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author liruixin
 * Date 2023-10-24
 * Time 16:02
 */
@Service
public class BreakContractOwnerRuleServiceImpl  implements BreakContractOwnerRuleService {


    @Autowired
    private BreakContractOwnerRuleDao breakContractOwnerRuleDao;
    @Autowired
    private BreakContractOwnerRuleStruct breakContractOwnerRuleStruct;

    @Override
    public void saveRule(BreakContractOwnerRuleAddParam param) {

        BreakContractOwnerRule rule = breakContractOwnerRuleDao.selectByName(param.getName()).orNull();
        if (rule != null) {throw new ServiceSystemException(PerformanceResultEnum.BREAK_CONTRACT_RULE_NAME_EXIST);}

        rule = new BreakContractOwnerRule();
        rule.setRuleJson(JSON.toJSONString(param));
        rule.setName(param.getName());
        rule.setFile("url");

        breakContractOwnerRuleDao.saveEntity(rule);
    }

    @Override
    public void updateStatus(BreakContractOwnerRuleStatusUpdateParam param) {
        BreakContractOwnerRule rule = breakContractOwnerRuleDao.getEntityByKey(param.getId()).orElseThrow(PerformanceResultEnum.BREAK_CONTRACT_RULE_NO_FOUND);

        rule.setStatus(param.getStatus());
        breakContractOwnerRuleDao.updateRule(rule);

    }

    @Override
    public BreakContractOwnerRuleVO getRuleInfo(Integer id) {
        BreakContractOwnerRule rule = breakContractOwnerRuleDao.getEntityByKey(id).orElseThrow(PerformanceResultEnum.BREAK_CONTRACT_RULE_NO_FOUND);

        BreakContractOwnerRuleVO vo = JSON.parseObject(rule.getRuleJson(), BreakContractOwnerRuleVO.class);
        vo.setId(rule.getId());
        vo.setName(rule.getName());
        vo.setStatus(rule.getStatus());

        return vo;
    }

    @Override
    public IPage<BreakContractOwnerRuleVO> pageRule(PageBreakContractOwnerRuleParam param) {
        return breakContractOwnerRuleDao.pageByParam(param);

    }

    @Override
    public List<BreakContractOwnerRuleVO> listPullDown() {
        return breakContractOwnerRuleStruct.convert(breakContractOwnerRuleDao.listEnable());
    }

}
