package com.clx.performance.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author kavin
 * Date 2023-09-17
 * Time 16:45
 */
@Getter
@Setter
@Accessors(chain = true)
@TableName("order_goods")
public class OrderGoods implements HasKey<Integer> {

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @TableField("order_no")
    @ApiModelProperty("订单编号")
    private String orderNo;

    @TableField("order_goods_no")
    @ApiModelProperty("货单编号")
    private String orderGoodsNo;

    @ApiModelProperty("用车需求： 1平台车辆 2部分平台车辆 3自有车辆")
    @TableField("truck_demand")
    private Integer truckDemand;

    @ApiModelProperty("用车方式 1：平台车辆配货 2：自有车辆配货")
    @TableField("vehicle_usage")
    private Integer vehicleUsage;

    @TableField("order_goods_status")
    @ApiModelProperty("货单状态")
    private Integer orderGoodsStatus;

    @TableField("loss_price")
    @ApiModelProperty("损耗单价(分)")
    private BigDecimal lossPrice;

    @TableField("extract_weight")
    @ApiModelProperty("提取吨数")
    private BigDecimal extractWeight;

    @TableField("residue_transport_weight")
    @ApiModelProperty("剩余拉运吨数")
    private BigDecimal residueTransportWeight;

    @TableField("already_transport_weight")
    @ApiModelProperty("已拉运吨数")
    private BigDecimal alreadyTransportWeight;

    @TableField("send_address_id")
    @ApiModelProperty("发货地址ID")
    private Integer sendAddressId;

    @TableField("send_address_shorter")
    @ApiModelProperty("发货地址简称")
    private String sendAddressShorter;

    @TableField("send_longitude")
    @ApiModelProperty("发货地址经度")
    private BigDecimal sendLongitude;

    @TableField("send_latitude")
    @ApiModelProperty("发货地址纬度")
    private BigDecimal sendLatitude;

    @TableField("receive_address_id")
    @ApiModelProperty("收货地址ID")
    private Integer receiveAddressId;

    @TableField("receive_address_shorter")
    @ApiModelProperty("收货地址简称")
    private String receiveAddressShorter;

    @TableField("receive_longitude")
    @ApiModelProperty("收货地址经度")
    private BigDecimal receiveLongitude;

    @TableField("receive_latitude")
    @ApiModelProperty("收货地址纬度")
    private BigDecimal receiveLatitude;

    @TableField("goods_id")
    @ApiModelProperty("货物ID")
    private Integer goodsId;

    @TableField("goods_name")
    @ApiModelProperty("货物名称")
    private String goodsName;

    @TableField("pending_order_way")
    @ApiModelProperty("挂单方式  1公开派单  2定向派单")
    private Integer pendingOrderWay;

    @TableField("directional_expire_time")
    @ApiModelProperty("定向运单失效时间")
    private LocalDateTime directionalExpireTime;


    @TableField("last_order_time")
    @ApiModelProperty("'最晚接单时间'")
    private LocalDateTime lastOrderTime;


    @TableField("last_arrive_send_time")
    @ApiModelProperty("最晚到达货源地时间")
    private LocalDateTime lastArriveSendTime;


    @TableField("last_load_time")
    @ApiModelProperty("最晚装货时间")
    private LocalDateTime lastLoadTime;


    @TableField("last_arrive_receive_time")
    @ApiModelProperty("'最晚到达目的地时间'")
    private LocalDateTime lastArriveReceiveTime;


    @TableField("pending_order_time")
    @ApiModelProperty("挂单时间")
    private LocalDateTime pendingOrderTime;

    @TableField("extract_way")
    @ApiModelProperty("提取方式 1提取全部 2提取部分")
    private Integer extractWay;

    @TableField("need_truck_num")
    @ApiModelProperty("需要车辆/辆")
    private Integer needTruckNum;

    @TableField("senior_logistics_manager_id")
    @ApiModelProperty("高级物流经理id")
    private Integer seniorLogisticsManagerId;

    @TableField("senior_logistics_manager_name")
    @ApiModelProperty("高级物流经理姓名")
    private String seniorLogisticsManagerName;

    @TableField("pending_order_freight")
    @ApiModelProperty("挂单运费")
    private BigDecimal pendingOrderFreight;

    @TableField("user_no")
    @ApiModelProperty("创建人用户编号")
    private Long userNo;

    @TableField("user_name")
    @ApiModelProperty("创建人姓名")
    private String userName;

    @TableField("settlement_account_period")
    @ApiModelProperty("结算账期  1拉运完成结  2月结")
    private String settlementAccountPeriod;

    @TableField("stop_flag")
    @ApiModelProperty("是否暂停 0：否   1：是")
    private Integer stopFlag;


    @TableField("create_time")
    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;

    @TableField("modified_time")
    @ApiModelProperty("修改时间")
    private LocalDateTime modifiedTime;

    @Override
    @KeyColumn("id")
    public Integer gainKey() {
    return this.id;
    }
}
