package com.clx.performance.listener;

import com.clx.performance.constant.RabbitKeyConstants;
import com.clx.performance.dao.OrderGoodsDao;
import com.clx.performance.enums.OrderGoodsStatusEnum;
import com.clx.performance.model.OrderGoods;
import com.clx.performance.service.IntegralMqService;
import com.clx.performance.service.OrderCancelService;
import com.msl.common.base.Optional;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 处理货单取消吨数回填
 */
@Slf4j
@Component
public class OrderCancelHandler {

    @Autowired
    private OrderCancelService orderCancelService;

    @RabbitListener(queues = RabbitKeyConstants.ORDER_GOODS_ON_DEAD_QUEUE)
    public void onMessage(String message) {
        log.info("处理订单取消监听器执行,订单No为{}", message);
        if (StringUtils.isBlank(message)) {
            return;
        }
        orderCancelService.ownerCancelOrder(message);
    }
}
