package com.clx.performance.controller.pc.breakcontract.carrier;

import com.baomidou.mybatisplus.core.metadata.IPage;

import com.clx.performance.param.pc.breakcontract.carrier.BreakContractOwnerRuleAddParam;
import com.clx.performance.param.pc.breakcontract.carrier.BreakContractOwnerRuleStatusUpdateParam;
import com.clx.performance.param.pc.breakcontract.carrier.PageBreakContractOwnerRuleParam;
import com.clx.performance.service.breakcontract.BreakContractOwnerRuleService;
import com.clx.performance.vo.pc.breakcontract.carrier.BreakContractOwnerRuleVO;
import com.msl.common.base.PageData;
import com.msl.common.convertor.aspect.UnitCovert;
import com.msl.common.result.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;


@Slf4j
@RestController
@RequestMapping(value="/pc/carrier/breakContract/ownerRule")
@Validated
@Api(tags = "承运端-货主违约规则")
@AllArgsConstructor
public class CarrierBreakContractOwnerRuleController {

    private final BreakContractOwnerRuleService breakContractOwnerRuleService;

    @ApiOperation(value = "新增货主违约规则", notes = "<br>By:艾庆国")
    @PostMapping("/saveRule")
    @UnitCovert
    public Result<Void> saveRule(@RequestBody @Validated BreakContractOwnerRuleAddParam param) {
        breakContractOwnerRuleService.saveRule(param);

        return Result.ok();
    }

    @ApiOperation(value = "更新状态", notes = "<br>By:艾庆国")
    @PostMapping("/updateStatus")
    public Result<Void> updateStatus(@RequestBody @Validated BreakContractOwnerRuleStatusUpdateParam param) {
        breakContractOwnerRuleService.updateStatus(param);

        return Result.ok();
    }

    @ApiOperation(value = "查询规则详情", notes = "<br>By:艾庆国")
    @GetMapping("/getRuleInfo")
    @UnitCovert(param = false)
    public Result<BreakContractOwnerRuleVO> getRuleInfo(Integer id) {

        return Result.ok(breakContractOwnerRuleService.getRuleInfo(id));
    }

    @ApiOperation(value = "分页搜索违约列表",notes = "<br>By:艾庆国")
    @PostMapping("/pageRule")
    @UnitCovert(param = false)
    public Result<PageData<BreakContractOwnerRuleVO>> pageRule(@RequestBody @Validated PageBreakContractOwnerRuleParam param) {
        IPage<BreakContractOwnerRuleVO> page = breakContractOwnerRuleService.pageRule(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }

    @ApiOperation(value = "查询方案下拉列表",notes = "<br>By:艾庆国")
    @PostMapping("/listPullDown")
    public Result<List<BreakContractOwnerRuleVO>> listPullDown() {
        return Result.ok(breakContractOwnerRuleService.listPullDown());
    }

}
