package com.clx.performance.param.pc.breakcontract.owner;

import com.msl.common.base.PageParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import javax.validation.constraints.NotNull;

@Getter
@Setter
@NoArgsConstructor
@ToString
public class PageOwnerBreakContractOwnerRecordParam extends PageParam {

    @ApiModelProperty(value = "货主编号", example = "1",hidden = true)
    private Long ownerUserNo;

    @ApiModelProperty(value = "订单号", example = "1000000000")
    private String orderNo;

    @NotNull(message = "违约方类型不能为空")
    @ApiModelProperty(value = "违约方类型：1平台 2货主 3司机", example = "1")
    private Integer breachContractPartyType;

    @ApiModelProperty(value = "缴费状态：0未缴费;1已缴费", example = "1")
    private Integer payStatus;

    @ApiModelProperty(value = "开始时间", example = "2012-01-01 00:00:00")
    private String beginTime;

    @ApiModelProperty(value = "结束时间", example = "2012-01-01 00:00:00")
    private String endTime;
}
