package com.clx.performance.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Optional;

public enum BreakContractSettlementDriverEnum {
    ;

    @Getter
    @AllArgsConstructor
    public enum BreachContractPartyType {
        PLATFORM(1, "平台"),
        OWNER(2, "货主"),
        DRIVER(3, "司机"),
        ;

        private final Integer code;
        private final String msg;

        public static Optional<BreachContractPartyType> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> e.code == code).findFirst();
        }

        public static String getMsgByCode(int code) {
            return getByCode(code).map(BreachContractPartyType::getMsg).orElse(null);
        }
    }

    @Getter
    @AllArgsConstructor
    public enum SettleStatus {
        NO(0, "待结算"),
        YES(1, "已结算"),
        ;

        private final Integer code;
        private final String msg;

        public static Optional<SettleStatus> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> e.code == code).findFirst();
        }

        public static String getMsgByCode(int code) {
            return getByCode(code).map(SettleStatus::getMsg).orElse(null);
        }
    }

    @Getter
    @AllArgsConstructor
    public enum SettlePlatform {
        MSL(0, "马上来"),
        ;

        private final Integer code;
        private final String msg;

        public static Optional<SettlePlatform> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> e.code == code).findFirst();
        }

        public static String getMsgByCode(int code) {
            return getByCode(code).map(SettlePlatform::getMsg).orElse(null);
        }
    }

}
