package com.clx.performance.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.clx.performance.constant.ActionConstants;
import com.clx.performance.dao.ThirdPartRequestLogDao;
import com.clx.performance.encryption.oldmsl.PayEncryptTools;
import com.clx.performance.encryption.oldmsl.PrivateKeyConfig;
import com.clx.performance.encryption.oldmsl.SystemCodeEnum;
import com.clx.performance.enums.PayUnitTypeEnum;
import com.clx.performance.enums.PerformanceResultEnum;
import com.clx.performance.enums.ThirdRequestTypeEnum;
import com.clx.performance.service.PaymentService;
import com.clx.performance.model.ThirdPartRequestLog;
import com.clx.performance.param.pc.payment.PayParam;
import com.clx.performance.param.pc.payment.PayUnitDTO;
import com.clx.performance.param.pc.payment.PayUserDTO;
import com.clx.performance.service.ThirdPartRequestLogService;
import com.msl.common.dto.HttpDTO;
import com.msl.common.exception.ServiceSystemException;
import com.msl.common.result.Result;
import com.msl.common.utils.EncryptUtil;
import com.msl.common.utils.HttpUtil;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import java.security.GeneralSecurityException;
import java.util.UUID;

import static com.clx.performance.enums.HttpEnum.PERFORMANCE_PAY_CLX_PAYMENT;

@Service
@Slf4j
@AllArgsConstructor
public class PaymentServiceImpl implements PaymentService {

    @Autowired
    ThirdPartRequestLogDao thirdPartRequestLogDao;

    @Autowired
    ThirdPartRequestLogService thirdPartRequestLogService;

    public static final String TRANSPORT_USER = "13403503399";
    public static final String TRANSPORT_KEY = "9Y1N5AUP8N2TI359";

    // 请求地址
    public static final String OLD_CLX_HOST = "https://api.clxkj.cn:8088";
    //回调地址
    public static final String NOTIFY_HOST = "https://gateway.testclx.cn";
    public static final String NOTIFY_URL = "/clx-performance/payment/notify/userPayNotify";

    @Override
    public Result paymentWallet(Integer fromUser, Integer toUser, Integer figure, String tradeNo, Integer id) {
        PayParam payDTO = new PayParam();
        payDTO.setPwd("noCheckPwd"); // 不校验密码
        payDTO.setFrom(fromUser);
        payDTO.setTo(toUser);
        payDTO.setTradeNo(tradeNo); // 流水号
        payDTO.setTradeId(id); //唯一id
        payDTO.setFigureFeeCode(10000);//默认到平台
        payDTO.setFigure(figure);
        return userPay(payDTO);
    }


    /**
     * 组装余额支付报文并发送请求
     */
    public  Result<Object> userPay(PayParam payDTO) {
        PayUnitDTO payUnitDTO = new PayUnitDTO();
        payUnitDTO.setId(payDTO.getTradeId().toString());
        payUnitDTO.setFrom(payDTO.getFrom());
        payUnitDTO.setTo(payDTO.getTo());
        payUnitDTO.setFigure(payDTO.getFigure());
        payUnitDTO.setType(PayUnitTypeEnum.RESIDUE_PAY.getCode());
        payUnitDTO.setTimestamp(System.currentTimeMillis() / 1000);
        payUnitDTO.setRemark("承运支付钱包转账");
        PayEncryptTools.sign(payUnitDTO, PrivateKeyConfig.privateKeyByte);// 用业务系统自己的私钥

        PayUserDTO payUserDTO = new PayUserDTO();
        payUserDTO.setPwd(payDTO.getPwd());
        payUserDTO.setSystem(SystemCodeEnum.MERCHANT_SERVICE.getCode()); //商户
        payUserDTO.setUserCode(payDTO.getFrom());
        payUserDTO.setOrderNo(payDTO.getTradeNo());
        payUserDTO.setUuid(UUID.randomUUID().toString().replaceAll("-", ""));
        payUserDTO.setNotifyUrl(NOTIFY_HOST+NOTIFY_URL);
//        payUserDTO.setFee(payDTO.getFigureFee());
         payUserDTO.setPayUnitDTO(payUnitDTO);
        payUserDTO.setFeeToUserCode(payDTO.getFigureFeeCode());
        log.info("发起支付请求日志 {}",payUserDTO);
        Result<Object> notify = (Result<Object>)postRequest(OLD_CLX_HOST+PERFORMANCE_PAY_CLX_PAYMENT.getUrl(), JSON.toJSONString(payUserDTO));
        log.info("支付返回日志 {}",notify);
        //Result<Object> notify = feignPaymentService.payUserMQ(payUserDTO);
//        if (notify == null) {
//            //FEGIN返回null
//            throw new ServiceSystemException(ResultCodeEnum.FEGIN_NULL);
//        }
//        if (notify.getCode() != 0) {
//        }
        return notify;
    }


    /**
     * post请求
     */
    @Transactional(propagation = Propagation.NOT_SUPPORTED)
    public Result<?> postRequest(String requestUrl, String param) {
        ThirdPartRequestLog log = ThirdPartRequestLog.builder()
                .requestId(UUID.randomUUID().toString())
                .appNo(Long.valueOf(10000)) //应用编号 10000 默认诚联信
                .requestType(ThirdRequestTypeEnum.SEND.getCode())
                .action(ActionConstants.CLX_PAYMENT_PAY)
                .url(requestUrl)
                .requestContent(param)
                .status(0) //状态: 0-请求中,1-成功,2-失败
                .build();
        thirdPartRequestLogDao.saveEntity(log);
        return encryptPost(requestUrl, param, log.getId());
    }

    private Result<?> encryptPost(String url, String param, Integer httpLogId) {
        try {
            return HttpUtil.post(url, null,
                    EncryptUtil.buildDTO(TRANSPORT_USER, param, TRANSPORT_KEY, System.currentTimeMillis()))
                    .map(r -> JSON.parseObject(r, new TypeReference<HttpDTO>() {
                    }))
                    .peek(dto -> log.info("http请求返回------dto->{}", dto))
                    .mapTry(dto -> EncryptUtil.decrypt(dto.getData(), TRANSPORT_KEY))
                    .map(this::covertResult)
                    .peek(result -> thirdPartRequestLogService.updateResult(httpLogId, result))
                    .filter(Result::succeed)
                    .orElseThrow();
        } catch (GeneralSecurityException e) {
            log.error("解密失败", e);
            throw new ServiceSystemException(PerformanceResultEnum.HTTP_ERROR, "http 请求异常");
        }
    }

    private <T> Result<?> covertResult(String result) {
        return JSON.parseObject(result, Result.class);
    }


}
