package com.clx.performance.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.clx.performance.dao.OrderGoodsDao;
import com.clx.performance.dao.OrderGoodsTruckBindDao;
import com.clx.performance.model.OrderGoods;
import com.clx.performance.model.OrderGoodsTruckBind;
import com.clx.performance.service.OrderGoodsTruckBindService;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

@Service
@AllArgsConstructor
@Slf4j
public class OrderGoodsTruckBindServiceImpl implements OrderGoodsTruckBindService {


    private final OrderGoodsTruckBindDao orderGoodsTruckBindDao;

    private final OrderGoodsDao orderGoodsDao;


    @Override
    public List<Integer> getTrucksByOrderGoodsNo(String orderGoodsNo) {
        return orderGoodsTruckBindDao.getTrucksByOrderGoodsNo(orderGoodsNo);
    }

    @Override
    public List<OrderGoods> getCancelOrderGoods(String truckNo, String beginTime, String endTime) {
        List<OrderGoodsTruckBind> list = orderGoodsTruckBindDao.getCancelOrderGoods(truckNo, beginTime, endTime);
        if (CollectionUtil.isEmpty(list)) {
            return null;
        }
        List<String> orderGoodsNoList = list.stream().map(OrderGoodsTruckBind::getOrderGoodsNo).collect(Collectors.toList());

        return orderGoodsDao.selectListByOrderGoodsList(orderGoodsNoList);
    }


}
