package com.clx.performance.dao.vehiclewarn;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.mapper.vehiclewarn.VehicleWarnInfoMapper;
import com.clx.performance.model.vehiclewarn.VehicleWarnInfo;
import com.clx.performance.param.pc.vehiclewarn.PageVehicleWarnInfoParam;
import com.msl.common.base.Optional;
import com.msl.common.dao.BaseDao;

import java.util.List;

public interface VehicleWarnInfoDao extends BaseDao<VehicleWarnInfoMapper, VehicleWarnInfo, Integer> {

    boolean updateStatus(VehicleWarnInfo item);
    boolean batchUpdateStatus(List<Integer> idList, Integer status);
    boolean updateSuspendTime(VehicleWarnInfo item, Integer warnRang);
    boolean updateWarnTime(VehicleWarnInfo item);

    Optional<VehicleWarnInfo> findById(Integer id);

    Optional<VehicleWarnInfo> findByChildNoAndWarnConfigId(String childNo, Integer warnConfigId);

    List<VehicleWarnInfo> listSuspendTimeout();

    IPage<VehicleWarnInfo> pageByParam(PageVehicleWarnInfoParam param);


}
