package com.clx.performance.vo.pc.trace;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.math.BigDecimal;

@Getter
@Setter
@NoArgsConstructor
public class DriverTruckTraceVO {

    @ApiModelProperty(value = "正北方向夹角", example = "12.34")
    private BigDecimal angle;
    @ApiModelProperty(value = "GPS 速度", example = "12.34")
    private BigDecimal speed;
    @ApiModelProperty(value = "里程", example = "12.34")
    private BigDecimal mileage;
    @ApiModelProperty(value = "海拔", example = "12.34")
    private BigDecimal height;
    @ApiModelProperty(value = "经度", example = "123.45")
    private BigDecimal longitude;
    @ApiModelProperty(value = "纬度", example = "12.34")
    private BigDecimal latitude;
    @ApiModelProperty(value = "GPS 时间")
    private String gpsTime;
    @ApiModelProperty(value = "停留结束时间")
    private String stayEndTime;
    @ApiModelProperty(value = "停留时长（min）", example = "12.3")
    private BigDecimal stayTime=BigDecimal.ZERO;
    @ApiModelProperty(value = "车辆状态：1空车 2重车", example = "1")
    private Integer truckStatus;
}
