package com.clx.performance.sqlProvider.settle;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.param.pc.PageNetworkAccountListParam;
import com.clx.performance.vo.pc.NetworkDriverAccountVO;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.jdbc.SQL;

public class NetworkDriverAccountProvider {

    public String networkAccountList(@Param("page") Page<NetworkDriverAccountVO> page, @Param("param") PageNetworkAccountListParam param) {
        String sql = new SQL() {{
            SELECT("a.id, a.driver_user_no," +
                    " a.driver_user_name, a.mobile, a.account_balance, " +
                    " a.usable_balance,a.frozen_balance,a.wallet_code,a.create_by,date_format(a.create_time, '%Y-%m-%d %H:%i:%s') as create_time");
            FROM("network_driver_account a");


            if (StringUtils.isNotBlank(param.getDriverUserNo())) {
                WHERE("a.driver_user_no = #{param.driverUserNo}");
            }
            if (StringUtils.isNotBlank(param.getMobile())) {
                WHERE("a.mobile = #{param.mobile}");
            }

            if (StringUtils.isNotBlank(param.getDriverUserName())) {
                WHERE("a.driver_user_name like CONCAT('%',#{param.driverUserName},'%')");
            }
            ORDER_BY("a.create_time desc");
        }}.toString();
        return sql;
    }

}
