package com.clx.performance.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.model.IntegralOrder;
import com.clx.performance.param.pc.pageIntegralOrderParam;
import com.clx.performance.sqlProvider.IntegralOrderSqlProvider;
import com.clx.performance.sqlProvider.IntegralTruckSqlProvider;
import com.clx.performance.vo.pc.IntegralOrderVO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.SelectProvider;

import java.util.List;

/**
* @Author: aiqinguo
* @Description: 积分货单
* @Date: 2023-10-9 11:52:22
* @Version: 1.0
*/

@Mapper
public interface IntegralOrderMapper extends BaseMapper<IntegralOrder> {

    /**
     * 查询是否存在(按货单编号)
     */
    @Select("SELECT IFNULL((SELECT 1 FROM integral_order WHERE order_goods_no=#{orderGoodsNo} LIMIT 1),0)")
    int existByOrderGoodsNo(@Param("orderGoodsNo")String orderGoodsNo);

    /**
     * @see IntegralOrderSqlProvider#pageByParam(com.baomidou.mybatisplus.extension.plugins.pagination.Page, com.clx.performance.param.pc.pageIntegralOrderParam)
     */
    @SelectProvider(type = IntegralOrderSqlProvider.class, method = "pageByParam")
    IPage<IntegralOrderVO> pageByParam(@Param("page") Page<IntegralOrderVO> page, @Param("param") pageIntegralOrderParam param);

    @Select("select order_goods_no from integral_order ")
    List<String> getAllOrderNoList();

}