package com.clx.performance.vo.pc.loan.carrier;

import com.clx.performance.enums.loan.OwnerLoanRecordEnum;
import com.msl.common.convertor.type.MoneyOutConvert;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;

import java.math.BigDecimal;

/**
 * @ClassName OrderPaymentDetailVO
 * @Description
 * @Author kavin
 * @Date 2024/1/24 16:45
 * @Version 1.0
 */

@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class OwnerOrderPaymentDetailVO {

    @ApiModelProperty("借款单号")
    private Long loanNo;

    @ApiModelProperty("付款方")
    private String lendingParty;

    @ApiModelProperty("付款账户")
    private String lendingPartyAccount;

    @ApiModelProperty("收款方")
    private String borrower;

    @ApiModelProperty("收款账户")
    private String borrowerAccount;

    @MoneyOutConvert
    @ApiModelProperty("订单金额")
    private BigDecimal loanBalance;



    @ApiModelProperty("10 待审批  20 审批通过   30 审批拒绝  40 付款中  50 付款成功 60 付款失败 ")
    private Integer status;

    @ApiModelProperty("订单支付状态 10 待付款 40 付款中 50 付款成功 60 付款失败")
    private String statusMsg;

    public String getStatusMsg(){
        return OwnerLoanRecordEnum.Status.getMsgByCode(status);
    }

    @ApiModelProperty("付款最终时间")
    public String finalPaymentTime;

    @ApiModelProperty("订单创建时间")
    public String createTime;

}
