package com.clx.performance.vo.pc.loan.carrier;

import com.clx.performance.enums.loan.OwnerLoanAccountRunningWaterRecordEnum;
import com.msl.common.convertor.type.MoneyOutConvert;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import java.math.BigDecimal;

/**
* @Author: aiqinguo
* @Description: 货主账户流水记录
* @Date: 2024/01/23 10:06:01
* @Version: 1.0
*/

@Schema(description = "货主账户流水记录")
@Getter
@Setter
@ToString
@NoArgsConstructor
public class OwnerLoanAccountRunningWaterRecordVO {

    @Schema(description = "id", example = "")
    private Integer id;
    @Schema(description = "货主编码", example = "1000000")
    private String ownerUserNo;
    @Schema(description = "货主名称", example = "张三")
    private String ownerUserName;
    @Schema(description = "联系电话", example = "13000000000")
    private String mobile;
    @Schema(description = "流水号", example = "100000")
    private Long runningWaterNo;
    @Schema(description = "借款单号", example = "100000")
    private Long loanNo;
    @Schema(description = "运单编号", example = "100000")
    private String childNo;
    @Schema(description = "流水类型 80：借款 90:冻结 100：运单抵扣 110:解冻", example = "10")
    private Integer runningWaterType;
    @Schema(description = "流水类型 80：借款 90:冻结 100：运单抵扣 110:解冻", example = "10")
    private String runningWaterTypeMsg;
    public String getRunningWaterTypeMsg() {
        return OwnerLoanAccountRunningWaterRecordEnum.RunWaterType.getMsgByCode(runningWaterType);
    }

    @MoneyOutConvert
    @Schema(description = "金额", example = "1.23")
    private BigDecimal alterationBalance;
    @MoneyOutConvert
    @Schema(description = "可用余额", example = "1.23")
    private BigDecimal useAbleBalance;
    @MoneyOutConvert
    @Schema(description = "冻结余额", example = "1.23")
    private BigDecimal frozenBalance;
    @MoneyOutConvert
    @Schema(description = "账户余额", example = "1.23")
    private BigDecimal accountBalance;
    @Schema(description = "创建人", example = "张三")
    private String createBy;
    @Schema(description = "创建时间", example = "")
    private String createTime;

}