package com.clx.performance.vo.pc.loan.carrier;

import com.clx.performance.enums.loan.OwnerLoanRecordEnum;
import com.msl.common.convertor.type.MoneyOutConvert;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.*;

import java.math.BigDecimal;

/**
 * @ClassName OrderPaymentDetailVO
 * @Description
 * @Author kavin
 * @Date 2024/1/24 16:45
 * @Version 1.0
 */

@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class CarrierOwnerOrderPaymentDetailVO {

    @Schema(description="借款单号")
    private Long loanNo;

    @Schema(description="付款方（借款记录中的借出方为现在的付款方）")
    private String payer;

    @Schema(description="付款账户（借款记录中的借出方账户为现在的付款方账户）")
    private String payerAccount;

    @Schema(description = "收款方",example = "馨祥和")
    private String payee;

    @Schema(description="收款账户")
    private String payeeAccount;

    @MoneyOutConvert
    @Schema(description="订单金额")
    private BigDecimal loanBalance;



    @Schema(description="10 待审批 15 待付款 20 审批通过   30 审批拒绝  40 付款中  50 付款成功 60 付款失败 ")
    private Integer status;

    @Schema(description="订单支付状态 10 待付款 40 付款中 50 付款成功 60 付款失败")
    private String statusMsg;

    public String getStatusMsg(){
        return OwnerLoanRecordEnum.Status.getMsgByCode(status);
    }

    @Schema(description="付款最终时间")
    public String finalPaymentTime;

    @Schema(description="订单创建时间")
    public String createTime;

}
