package com.clx.performance.vo.pc;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import java.math.BigDecimal;

@Getter
@Setter
@ToString
@NoArgsConstructor
public class OutputMonitorOrderChildVO {


    @Schema(description = "发货地址")
    private String sendAddress;

    @Schema(description = "发货地址Id")
    private Integer sendAddressId;


    @Schema(description = "状态  运单状态  10：已接单  20:支付 30：前往货源地 40：到达货源地 50：装货成功 60：前往目的地 70：到达目的地 80：收货待确认  90：待结算 100：完成  110:司机取消  111:承运取消   112:货主取消 ")
    private Integer status;

    @Schema(description = "预计到货源地时间")
    private String expectArriveTime;

    @Schema(description = "预计到货源地时间-实时")
    private String expectArriveTimeRealTime;

    @Schema(description = "预计到货源地趋势 0 前进 1 后退")
    private Integer arriveTrend;

    @Schema(description = "预计到收货地时间")
    private String expectReceiveTime;

    @Schema(description = "预计到收货地时间-实时")
    private String expectReceiveTimeRealTime;

    @Schema(description = "预计到收货地趋势 0 前进 1 后退")
    private Integer receiveTrend;

    @Schema(description = "预计运输时间")
    private String expectTransportTime;

    @Schema(description = "装车预警 0 不预警 1 预警")
    private Integer loadWarning;

    @Schema(description = "货源地预警 0 不预警 1 预警")
    private Integer arriveWarning;

    @Schema(description = "收货地预警 0 不预警 1 预警")
    private Integer receiveWarning;

    @Schema(description = "车牌号")
    private String truckNo;

    @Schema(description = "司机姓名")
    private String driverName;

    @Schema(description = "司机手机号")
    private String driverMobile;

    @Schema(description = "装车吨数")
    private BigDecimal loadNet;

    @Schema(description = "接单时间")
    private String payTime;

    @Schema(description = "装车时间")
    private String loadTime;

    @Schema(description = "运单号")
    private String childNo;

}
