package com.clx.performance.vo.pc;

import com.clx.performance.util.NumberToChineseUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.*;

import java.util.Arrays;
import java.util.List;

/**
* @Author: aiqinguo
* @Description: 积分车辆
* @Date: 2023-10-9 13:36:29
* @Version: 1.0
*/

@Schema(description = "积分车辆")
@Getter
@Setter
@ToString
@NoArgsConstructor
public class IntegralTruckVO {

    @Schema(description = "id", example = "")
    private Integer id;
    @Schema(description = "车牌号", example = "京A12345")
    private String truckNo;
    @Schema(description = "司机姓名", example = "张三")
    private String driverName;
    @Schema(description = "司机手机号", example = "13000000000")
    private String driverMobile;

    @Schema(description = "梯队", example = "1")
    private Integer echelon;
    @Schema(description = "梯队", example = "第一梯队")
    private String echelonMsg;
    public String getEchelonMsg() {
        return echelonMsg = "第"+ NumberToChineseUtil.convertToChinese(echelon)+"梯队";
    }

    @Schema(description = "积分", example = "1")
    private Integer integral;
    @Schema(description = "排名", example = "1")
    private Integer rank;

    @Schema(description = "创建时间", example = "")
    private String createTime;

    @Schema(description = "运单完成积分", example = "1")
    private Integer orderChildCompleteIntegral=0;
    @Schema(description = "平台补偿积分", example = "1")
    private Integer platformCompensationIntegral=0;
    @Schema(description = "运单取消积分", example = "1")
    private Integer orderChildCancelIntegral=0;
    @Schema(description = "运单超时积分", example = "1")
    private Integer orderChildTimeoutIntegral=0;
    @Schema(description = "信息上报积分", example = "1")
    private Integer reportIntegral=0;

    @Schema(description = "信息上报积分", example = "1")
    private List<IntegralItem> integralItemList;
    public List<IntegralItem> getIntegralItemList() {
        return Arrays.asList(
                new IntegralItem("运单完成积分", orderChildCompleteIntegral),
                new IntegralItem("平台补偿积分", platformCompensationIntegral),
                new IntegralItem("运单取消扣减", orderChildCancelIntegral),
                new IntegralItem("运单超时扣减", orderChildTimeoutIntegral),
                new IntegralItem("信息上报积分", reportIntegral)
        );
    }

    @Getter
    @Setter
    @ToString
    @NoArgsConstructor
    @AllArgsConstructor
    public static class IntegralItem{
        @Schema(description = "名称", example = "1")
        private String name;
        @Schema(description = "信息上报积分", example = "1")
        private Integer integral;
    }

}