package com.clx.performance.param.pc.loan.carrier;

import com.msl.common.base.PageParam;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

@Getter
@Setter
@NoArgsConstructor
@ToString
public class PageOwnerLoanRecordOfOwner extends PageParam {

    @Schema(description = "货主编码", example = "10000000")
    private Long ownerUserNo;

    @Schema(description = "借款单号", example = "100000000")
    private Long loanNo;

    @Schema(description = "交易流水号（第三方）", example = "11000000000")
    private String runningWaterOpenNo;

    @Schema(description = "借款类型 1:虚拟货币  2:资金", example = "1")
    private Integer loanType;

    @Schema(description = "10 待审批 15 待付款 20 审批通过   30 审批拒绝  40 付款中  50 付款成功 60 付款失败 ", example = "1")
    private Integer status;

}