package com.clx.performance.param.pc.customer;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.*;

import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.List;

/**
 * @ClassName saveCustomerComplaintDetailParam
 * @Description
 * @Author kavin
 * @Date 2023/12/8 13:52
 * @Version 1.0
 */

@Getter
@Setter
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class SaveCustomerComplaintDetailParam {

    @NotNull(message = "投诉类型ID不能为空")
    @Schema(description="投诉类型ID")
    private Integer complaintTypeId;             //投诉类型id

    @Schema(description="运单编号")
    private String childNo;                         //运单编号

    @Size(min=1 ,max = 1000)
    @Schema(description="运单编号")
    private String content;                      //问题描述

    @Schema(description="图片")
    private List<String> picture;                      //图片

}
