package com.clx.performance.param.app;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.List;

@Getter
@Setter
@NoArgsConstructor
public class OrderChildLoadParam extends PositionParam {

    @Schema(description = "运单编号", example = "100000000")
    @NotBlank(message = "运单编号不能为空")
    private String childNo;

    @Schema(description = "装货毛重（单位吨）", example = "2.46")
    private BigDecimal loadRough;

    @Schema(description = "装货皮重（单位吨）", example = "1.23")
    private BigDecimal loadTare;

    @Schema(description = "装货净重（单位吨）", example = "1.23")
    private BigDecimal loadNet;

    @Schema(description = "磅单图片列表")
    @NotEmpty(message = "请上传磅单照片")
    private List<String> loadImageList;

    @Schema(description = "装货时间")
    private String loadTime;
}
