package com.clx.performance.enums.settle;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;


public enum SettlementOwnerEnum {
    ;
    @Getter
    @AllArgsConstructor
    public enum InvoiceType {
        ONLINE(1, "网运单"),
        ORDINARY(2, "普通单");
        private final Integer code;
        private final String msg;

        public static Optional<InvoiceType> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> Objects.equals(e.getCode(), code)).findFirst();
        }

        public static String getMsgByCode(int code) {
            return getByCode(code).map(InvoiceType::getMsg).orElse(null);
        }
    }


    @Getter
    @AllArgsConstructor
    public enum InvoiceStatus {
        INVOICED(1, "已开票"),
        NOT_INVOICE(2, "未开票"),
        NO_NEED_INVOICE(3, "无需开票"),
        PART_INVOICE(4, "部分开票")

        ;
        private final Integer code;
        private final String msg;

        public static Optional<InvoiceStatus> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> Objects.equals(e.getCode(), code)).findFirst();
        }

        public static String getMsgByCode(int code) {
            return getByCode(code).map(InvoiceStatus::getMsg).orElse(null);
        }
    }

    @Getter
    @AllArgsConstructor
    public enum Status {
        TO_BE_LOCKED(10, "待锁定"),
        TO_BE_ACCOUNT(20, "待对账"),
        PLATFORM_TO_BE_CONFIRMED(21, "待平台确认"),
        OWNER_TO_BE_CONFIRMED(30, "待货主确认"),
        SHIPPER_TO_PAYMENT (40, "待货主付款"),
        PLATFORM_CONFIRMED_OWNER_PAYMENT(50, "待平台确认付款"),
        PLATFORM_TO_PAYMENT(60, "待平台付款"),
        OWNER_CONFIRMED_PLATFORM_PAYMENT(70, "待货主确认付款"),

        @Deprecated
        INVOICE_TO_BE_MAILED(80, "待邮寄发票"),

        COMPLETED(90, "已完结"),

        ;

        private final Integer code;
        private final String msg;

        public static Optional<Status> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> Objects.equals(e.getCode(), code)).findFirst();
        }

        public static String getMsgByCode(int code) {
            return getByCode(code).map(Status::getMsg).orElse(null);
        }
    }

    @Getter
    @AllArgsConstructor
    public enum MergeStatus {
        NO(0, "否"),
        YES(1, "是"),
        ;
        private final Integer code;
        private final String msg;

        public static Optional<MergeStatus> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> Objects.equals(e.getCode(), code)).findFirst();
        }

        public static String getMsgByCode(int code) {
            return getByCode(code).map(MergeStatus::getMsg).orElse(null);
        }
    }

    @Getter
    @AllArgsConstructor
    public enum SettlementPeriodType {

        IMMEDIATE(1, "拉运完成结算"),
        MONTH(2, "月结"),
        DAILY(3, "日结"),

        ;

        private final int code;
        private final String name;

        public static Optional<SettlementPeriodType> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> e.code == code).findFirst();
        }
    }

    @Getter
    @AllArgsConstructor
    public enum MergeSettlementFlag {


        //1:普通结算单  2:合并结算单
        COMMON(1, "普通结算单"),
        MERGE(2, "合并结算单"),
        ;

        private final int code;
        private final String name;

        public static Optional<MergeSettlementFlag> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> e.code == code).findFirst();
        }
    }

    @Getter
    @AllArgsConstructor
    public enum InvoiceConfigType {
        NO(0, "否"),
        YES(1, "是"),
        ;

        private final Integer code;
        private final String msg;

        public static Optional<InvoiceConfigType> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> e.code == code).findFirst();
        }

        public static String getMsgByCode(int code) {
            return getByCode(code).map(InvoiceConfigType::getMsg).orElse(null);
        }
    }



}
