package com.clx.performance.model.breakcontract;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;

/**
 * @author liruixin
 * Date 2023-10-24
 * Time 16:02
 */
@Getter
@Setter
@Accessors(chain = true)
@TableName("break_contract_driver_record")
public class BreakContractDriverRecord  implements HasKey<Integer> {

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @TableField("trigger_type")
    @Schema(description="触发类型：1系统触发 2手动触发")
    private Integer triggerType;

    @TableField("break_contract_party_type")
    @Schema(description="违约方类型：1平台 2货主 3车主")
    private Integer breakContractPartyType;

    @TableField("break_no")
    @Schema(description = "违约单号", example = "")
    private String breakNo;

    @TableField("child_no")
    @Schema(description="违约运单")
    private String childNo;

    @TableField("truck_no")
    @Schema(description="车牌号")
    private String truckNo;

    @TableField("truck_own_user_no")
    @Schema(description="车主用户编号")
    private Long truckOwnUserNo;

    @TableField("truck_own_name")
    @Schema(description="车主名称")
    private String truckOwnName;

    @TableField("driver_user_no")
    @Schema(description="司机用户编号")
    private Long driverUserNo;

    @TableField("driver_name")
    @Schema(description="司机名称")
    private String driverName;

    @TableField("figure")
    @Schema(description="违约金")
    private BigDecimal figure;

    @TableField("time_limit")
    @Schema(description="接单时间限制（小时）")
    private BigDecimal timeLimit;

    @TableField("limit_time")
    @Schema(description="接单限制时间")
    private LocalDateTime limitTime;

    @TableField("settlement_no")
    @Schema(description="结算单编号")
    private String settlementNo;

    @TableField("remark")
    @Schema(description="备注")
    private String remark;

    @TableField("create_by")
    @Schema(description = "操作人编号", example = "")
    private Long createBy;

    @TableField("create_name")
    @Schema(description = "操作人名称", example = "")
    private String createName;

    @TableField("create_time")
    @Schema(description="创建时间")
    private LocalDateTime createTime;

    @TableField("modified_time")
    @Schema(description="修改时间")
    private LocalDateTime modifiedTime;

    @Override
    @KeyColumn("id")
    public Integer gainKey() {
    return this.id;
    }
}
