package com.clx.performance.controller.pc;

import com.clx.performance.dto.zjxl.TruckTraceDTO;
import com.clx.performance.param.pc.*;
import com.clx.performance.service.TruckService;
import com.clx.performance.vo.pc.OrderGoodsTruckListVO;
import com.clx.performance.vo.pc.PageTruckListVO;
import com.clx.performance.vo.pc.TruckTraceVO;
import com.msl.common.base.PageData;
import com.msl.common.result.Result;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.Operation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @ClassName GoodsOrderController
 * @Description
 * @Author kavin
 * @Date 2023/9/17 17:16
 * @Version 1.0
 */

@Slf4j
@RestController
@RequestMapping("/pc/truck")
@Validated
@Tag(name = "PC-车辆列表")
public class TruckController {

    @Autowired
    TruckService truckService;

    
    @Operation(summary = "获取车辆列表", description = "<br>By:刘海泉")
    @PostMapping("/pageTruckList")
    public Result<PageData<PageTruckListVO>> pageTruckList(@RequestBody @Validated PageTruckListParam param) {
        PageData<PageTruckListVO> page = truckService.pageTruckList(param);
        return Result.ok(page);
    }

    @Operation(summary = "手动更新平台车辆定位信息", description = "<br>By:刘海泉")
    @GetMapping("/handExecTruckTrace")
    public Result handExecTruckTrace() {
        truckService.handExecTruckTrace();
        return Result.ok();
    }



    @Operation(summary = "获取附近的车辆", description = "<br>By:刘海泉")
    @PostMapping("/getVicinityTruckList")
    public Result<PageData<PageTruckListVO>> getVicinityTruckList(@RequestBody @Validated PageVicinityTruckListParam param) {
        PageData<PageTruckListVO> page = truckService.getVicinityTruckList(param);
        return Result.ok(page);
    }

    @Operation(summary = "手动添加中交兴路的车辆定位信息", description = "<br>By:刘海泉")
    @PostMapping("/addTruckGPSInfo")
    public Result addTruckGPSInfo(@RequestBody @Validated TruckTraceDTO truckTraceDTO) {
        truckService.addTruckGPSInfo(truckTraceDTO);
        return Result.ok();
    }



    @Operation(summary = "获取货单选择的车辆列表", description = "<br>By:刘海泉")
    @PostMapping("/getOrderGoodsTruckList")
    public Result<List<OrderGoodsTruckListVO>> getOrderGoodsTruckList(@RequestBody @Validated OrderGoodsTruckListParam param) {
        List<OrderGoodsTruckListVO> list = truckService.getOrderGoodsTruckList(param);
        return Result.ok(list);
    }

    @Operation(summary = "获取某辆车的轨迹信息", description = "<br>By:刘海泉")
    @PostMapping("/getTruckTrace")
    public Result<List<TruckTraceVO>> getTruckTrace(@RequestBody @Validated TruckTraceParam param) {
        List<TruckTraceVO> list = truckService.getTruckTrace(param);
        return Result.ok(list);
    }


    @Operation(summary = "判断车辆状态", description = "<br>By:刘海泉")
    @PostMapping("/judgeTruckStatus")
    public Result<List<String>> judgeTruckStatus(@RequestBody @Validated JudgeTruckStatusParam param) {
        List<String> list = truckService.judgeTruckStatus(param);
        return Result.ok(list);
    }
}
