package com.clx.performance.sqlProvider;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.param.pc.OrderChildCancelRecordParam;
import com.clx.performance.vo.app.OrderChildVO;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.jdbc.SQL;

public class OrderChildOperateRecordSqlProvider {

    public String orderChildOperateRecord(@Param("page") Page<OrderChildVO> page, @Param("param") OrderChildCancelRecordParam param) {
        return new SQL() {{
            SELECT("id," +
                    "child_no," +
                    "type," +
                    "truck_no," +
                    "driver_name," +
                    "driver_mobile," +
                    "send_address," +
                    "receive_address," +
                    "good_type_name," +
                    "remark," +
                    "date_format(operate_time, '%Y-%m-%d %H:%i:%s') as operateTime," +
                    "operator"
            );
            FROM("order_child_operate_record ");
            ORDER_BY("create_time desc");
        }}.toString();
    }
}
