package com.clx.performance.service.impl.child;

import com.clx.performance.dao.OrderGoodsDao;
import com.clx.performance.enums.*;
import com.clx.performance.model.OrderChild;
import com.clx.performance.model.OrderChildPoundAudit;
import com.clx.performance.model.OrderGoods;
import com.clx.performance.model.settle.SettlementDriverDetail;
import com.clx.performance.param.mq.IntegralOrderChildFinishMqParam;
import com.clx.performance.service.IntegralMqService;
import com.clx.performance.service.OrderChildMqService;
import com.clx.performance.service.breakcontract.BreakContractDriverRecordService;
import com.clx.performance.service.child.OrderChildPostService;
import com.clx.performance.service.settle.SettlementDriverDetailService;
import com.clx.performance.service.settle.SettlementMqService;
import com.clx.performance.service.settle.SettlementOwnerDetailService;
import com.clx.performance.service.vehiclewarn.VehicleWarnMqService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Objects;

@Slf4j
@Service
public class OrderChildPostServiceImpl implements OrderChildPostService {

    @Autowired
    private IntegralMqService integralMqService;

    @Autowired
    private OrderChildMqService orderChildMqService;

    @Autowired
    private BreakContractDriverRecordService breakContractDriverRecordService;

    @Autowired
    private VehicleWarnMqService vehicleWarnMqService;

    @Autowired
    private SettlementDriverDetailService settlementDriverDetailService;

    @Autowired
    private SettlementOwnerDetailService settlementOwnerDetailService;

    @Autowired
    private SettlementMqService settlementMqService;

    @Autowired
    private OrderGoodsDao orderGoodsDao;

    @Override
    public void orderChildAdd(String childNo) {
        // 发送mq 新增运单
        orderChildMqService.orderChildAdd(childNo);

        // 发送mq (运单新增)
        vehicleWarnMqService.orderChildAdd(childNo);
    }

    @Override
    public void orderChildArriveReceiveAddress(OrderChild orderChild) {
        // 保存违约记录
        breakContractDriverRecordService.saveDriverRecordOfArriveReceiveAddress(orderChild, 0L, "系统");


        // 到达货源地 统计积分
        integralMqService.orderChildFinish(orderChild.getChildNo(), IntegralOrderChildFinishMqParam.Type.ARRIVE_RECEIVE_ADDRESS_TIMEOUT.getCode());

        // 发送mq (到达货源地)
        orderChildMqService.orderChildArriveReceiveAddress(orderChild.getChildNo());

    }

    /**
     * 司机确认收货
     */
    @Override
    public void orderChildDriverConfirm(OrderChild orderChild) {

        // 司机确认收货 统计积分
        integralMqService.orderChildFinish(orderChild.getChildNo(), IntegralOrderChildFinishMqParam.Type.DRIVER_CONFIRM.getCode());

        orderChildFinish(orderChild.getChildNo());

        // 发送mq 司机确认收货
        orderChildMqService.orderChildDriverConfirm(orderChild.getChildNo());
    }


    /**
     * 司机取消
     */
    @Override
    public void orderChildCancelByDriver(OrderChild orderChild, Integer opUserType, Long opUserNo, String opUserName){
        // 司机取消 统计积分
        integralMqService.orderChildFinish(orderChild.getChildNo(), IntegralOrderChildFinishMqParam.Type.DRIVER_CANCEL.getCode());

        orderChildFinish(orderChild.getChildNo());

        // 发送mq （运单取消）
        orderChildMqService.orderChildCancel(orderChild.getChildNo(), orderChild.getStatus(), opUserType, opUserNo, opUserName);
    }

    /**
     * 承运取消
     */
    @Override
    public void orderChildCancelByCarrier(OrderChild orderChild, Integer opUserType, Long opUserNo, String opUserName) {

        // 承运取消 统计积分
        integralMqService.orderChildFinish(orderChild.getChildNo(), IntegralOrderChildFinishMqParam.Type.CARRIER_CANCEL.getCode());

        orderChildFinish(orderChild.getChildNo());

        // 发送mq （运单取消）
        orderChildMqService.orderChildCancel(orderChild.getChildNo(), orderChild.getStatus(), opUserType, opUserNo, opUserName);

    }

    /**
     * 到达货源地超时取消
     */
    @Override
    public void arriveSendAddressTimeoutCancel(OrderChild orderChild){

        // 保存违约记录
        breakContractDriverRecordService.saveDriverRecordOfArriveSendAddressTimeout(orderChild, 0L, "系统");

        // 到达货源地超时取消 统计积分
        integralMqService.orderChildFinish(orderChild.getChildNo(), IntegralOrderChildFinishMqParam.Type.ARRIVE_SEND_ADDRESS_TIMEOUT_CANCEL.getCode());

        orderChildFinish(orderChild.getChildNo());

        // 发送mq （运单取消）
        orderChildMqService.orderChildCancel(orderChild.getChildNo(), OrderChildLogEnum.Type.PLATFORM_CANCEL.getCode(), UserTypeEnum.SYSTEM.getCode(), 0L, "系统");

    }

    /**
     * 订单取消
     */
    @Override
    public void orderCancel(String childNo) {

        // 订单取消 统计积分
        integralMqService.orderChildFinish(childNo, IntegralOrderChildFinishMqParam.Type.ORDER_CANCEL.getCode());

        orderChildFinish(childNo);

        // 发送mq （运单取消）
        orderChildMqService.orderChildCancel(childNo, OrderChildEnum.Status.PLATFORM_CANCEL.getCode(), UserTypeEnum.SYSTEM.getCode(), 0L, "系统");

    }

    /**
     * 货单取消
     */
    @Override
    public void orderGoodsCancel(String childNo) {

        // 货单取消 统计积分
        integralMqService.orderChildFinish(childNo, IntegralOrderChildFinishMqParam.Type.ORDER_GOODS_CANCEL.getCode());

        orderChildFinish(childNo);

        // 发送mq （运单取消）
        orderChildMqService.orderChildCancel(childNo, OrderChildEnum.Status.PLATFORM_CANCEL.getCode(), UserTypeEnum.SYSTEM.getCode(), 0L, "系统");

    }

    /**
     * 客服取消
     */
    @Override
    public void orderChildCancelByArtificial(String childNo) {
        // 货单取消 统计积分
        integralMqService.orderChildFinish(childNo, IntegralOrderChildFinishMqParam.Type.ARTIFICIAL_CANCEL.getCode());

        orderChildFinish(childNo);

        // 发送mq （运单取消）
        orderChildMqService.orderChildCancel(childNo, OrderChildEnum.Status.ARTIFICIAL_CANCEL.getCode(), UserTypeEnum.CARRIER.getCode(), 0L, "系统");

    }

    /**
     * 运单结束
     */
    @Override
    public void orderChildFinish(String childNo) {

    }

    @Override
    public void orderChildPoundAudit(OrderChild orderChild, OrderChildPoundAudit poundAuditDetail){
        OrderGoods orderGoods = orderGoodsDao.getByOrderGoodsNo(orderChild.getOrderGoodsNo()).orElseThrow(
                PerformanceResultEnum.DATA_NOT_FIND);

        if (Objects.equals(poundAuditDetail.getStatus(), OrderChildPoundAuditEnum.Status.APPROVED.getCode())) {
            // 生成计费单
            SettlementDriverDetail settlementDriverDetail = settlementDriverDetailService.saveSettlementDetail(orderChild);
            Integer settlementOwnerDetailId = settlementOwnerDetailService.saveSettlementDetail(orderChild, orderGoods, settlementDriverDetail);
            log.info("生成计费单 {} ", orderChild.getChildNo());
            settlementMqService.settlementDetailAdd(settlementDriverDetail.getId(), settlementOwnerDetailId);
        }
    }

}
