package com.clx.performance.dao.settle;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.mapper.settle.SettlementOwnerDetailMapper;
import com.clx.performance.model.settle.SettlementOwnerDetail;
import com.clx.performance.param.pc.carrier.ExportBatchOwnerSettlementDetailParam;
import com.clx.performance.param.pc.owner.PageCarrierSettlementOwnerDetailParam;
import com.clx.performance.param.pc.owner.PageInvoiceOwnerSettlementOwnerDetailParam;
import com.clx.performance.param.pc.owner.PageOwnerSettlementOwnerDetailParam;
import com.clx.performance.param.pc.owner.PagePendingCarrierSettlementOwnerDetailParam;
import com.msl.common.base.Optional;
import com.msl.common.dao.BaseDao;
import org.apache.ibatis.annotations.Param;

import java.util.List;


/**
 * @Author: aiqinguo
 * @Description: 货主运单计费明细
 * @Date: 2023-10-11 18:00:53
 * @Version: 1.0
 */
public interface SettlementOwnerDetailDao extends BaseDao<SettlementOwnerDetailMapper, SettlementOwnerDetail, Integer> {

    boolean updateInvoiceTypeStatus(SettlementOwnerDetail item);
    boolean updateClearInvoiceCompany(SettlementOwnerDetail item);
    boolean updateInvoiceType(SettlementOwnerDetail item);
    boolean updatePayStatus(SettlementOwnerDetail item);
    boolean updateSettlementNo(SettlementOwnerDetail item);

    boolean updateInvoiceStatusBySettlementNo(@Param("settlementNo")String settlementNo, @Param("invoiceStatus")Integer invoiceStatus);

    boolean updateFinalPaymentStatusBySettlementNo(@Param("settlementNo")String settlementNo, @Param("finalPaymentStatus")Integer finalPaymentStatus);

    Optional<SettlementOwnerDetail> getByChildNo(String childNo);
    List<SettlementOwnerDetail> getBySettlementNo(String settlementNo);

    List<SettlementOwnerDetail> getBySettlementNoAndInvoiceType(String settlementNo, Integer invoiceType, Integer invoiceStatus);

    IPage<SettlementOwnerDetail> pageOwnerSettlementOrderDetailList(PageOwnerSettlementOwnerDetailParam param);

    IPage<SettlementOwnerDetail> pageInvoiceOwnerSettlementOrderDetailList(PageInvoiceOwnerSettlementOwnerDetailParam param);

    IPage<SettlementOwnerDetail> pageSettlementOwnerDetail(PageCarrierSettlementOwnerDetailParam param);

    Integer getInvoiceType(String orderNo);

    void updateSettlementByChildNoList(List<String> childNoList);

    void updateFinalPaymentStatusBySettlementNoForOnline(String settlementNo, Integer finalPaymentStatus);

    List<SettlementOwnerDetail> selectListByOrderNo(String orderNo);

    void updateSettlementMerge(String settlementNo, List<String> settlementNos);

    List<SettlementOwnerDetail>listInvoiceStatusSync();

    List<SettlementOwnerDetail> listPayStatusSync();
    List<SettlementOwnerDetail> listInvoiceTypeSync();

    IPage<SettlementOwnerDetail> pagePendingSettlementOwnerDetail(PagePendingCarrierSettlementOwnerDetailParam param);

    List<SettlementOwnerDetail> listSettlementOwnerDetailBySettlementNos(ExportBatchOwnerSettlementDetailParam param);
}
