package com.clx.performance.dao.impl.settle;

import cn.hutool.core.date.LocalDateTimeUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.dao.settle.SettlementOwnerDetailDao;
import com.clx.performance.enums.settle.SettlementOwnerDetailEnum;
import com.clx.performance.enums.settle.SettlementOwnerEnum;
import com.clx.performance.mapper.settle.SettlementOwnerDetailMapper;
import com.clx.performance.model.settle.SettlementDriverDetail;
import com.clx.performance.model.settle.SettlementOwnerDetail;
import com.clx.performance.param.pc.carrier.ExportBatchOwnerSettlementDetailParam;
import com.clx.performance.param.pc.owner.PageCarrierSettlementOwnerDetailParam;
import com.clx.performance.param.pc.owner.PageInvoiceOwnerSettlementOwnerDetailParam;
import com.clx.performance.param.pc.owner.PageOwnerSettlementOwnerDetailParam;
import com.clx.performance.param.pc.owner.PagePendingCarrierSettlementOwnerDetailParam;
import com.msl.common.base.Optional;
import com.msl.common.dao.impl.BaseDaoImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;

import static com.clx.performance.enums.settle.SettlementOwnerDetailEnum.HandleStatus.NO;
import static com.clx.performance.enums.settle.SettlementOwnerDetailEnum.HandleStatus.YES;
import static com.clx.performance.enums.settle.SettlementOwnerEnum.InvoiceType.ORDINARY;

/**
 * @Author: aiqinguo
 * @Description: 货主运单计费明细
 * @Date: 2023-10-11 18:04:09
 * @Version: 1.0
 */
@Repository
public class SettlementOwnerDetailDaoImpl extends BaseDaoImpl<SettlementOwnerDetailMapper, SettlementOwnerDetail, Integer> implements SettlementOwnerDetailDao {

    @Override
    public boolean updateInvoiceTypeStatus(SettlementOwnerDetail item) {
        return update(lUdWrapper()
                .eq(SettlementOwnerDetail::getId, item.getId())
                .set(SettlementOwnerDetail::getInvoiceTypeStatus, item.getInvoiceTypeStatus())
        );
    }

    @Override
    public boolean updateClearInvoiceCompany(SettlementOwnerDetail item) {
        return update(lUdWrapper()
                .eq(SettlementOwnerDetail::getId, item.getId())
                .set(SettlementOwnerDetail::getInvoicingCompanyId, item.getInvoicingCompanyId())
                .set(SettlementOwnerDetail::getInvoicingCompanyShorterName, item.getInvoicingCompanyShorterName())
                .set(SettlementOwnerDetail::getInvoicingCompanyGroupCode, item.getInvoicingCompanyGroupCode())
        );
    }

    @Override
    public boolean updateInvoiceType(SettlementOwnerDetail item) {
        return update(lUdWrapper()
                .eq(SettlementOwnerDetail::getId, item.getId())
                .set(SettlementOwnerDetail::getInvoiceType, item.getInvoiceType())
                .set(SettlementOwnerDetail::getInvoiceFreight, item.getInvoiceFreight())
                .set(SettlementOwnerDetail::getSettlementFreight, item.getSettlementFreight())
                .set(SettlementOwnerDetail::getFinalPaymentStatus, item.getFinalPaymentStatus())
                .set(SettlementOwnerDetail::getPrepayFreight, item.getPrepayFreight())
                .set(SettlementOwnerDetail::getLoanFreight, item.getLoanFreight())

                .set(SettlementOwnerDetail::getInvoicingCompanyId, item.getInvoicingCompanyId())
                .set(SettlementOwnerDetail::getInvoicingCompanyShorterName, item.getInvoicingCompanyShorterName())
                .set(SettlementOwnerDetail::getInvoicingCompanyGroupCode, item.getInvoicingCompanyGroupCode())
                .set(SettlementOwnerDetail::getInvoiceServiceFeeRate, item.getInvoiceServiceFeeRate())
                .set(SettlementOwnerDetail::getInvoiceServiceFee, item.getInvoiceServiceFee())
                .set(SettlementOwnerDetail::getRemark, item.getRemark())
        );
    }

    @Override
    public boolean updatePayStatus(SettlementOwnerDetail item) {
        return update(lUdWrapper()
                .eq(SettlementOwnerDetail::getId, item.getId())
                .set(SettlementOwnerDetail::getPayStatus, item.getPayStatus())
        );
    }

    @Override
    public boolean updateSettlementNo(SettlementOwnerDetail item) {
        return update(lUdWrapper()
                .eq(SettlementOwnerDetail::getId, item.getId())
                .set(SettlementOwnerDetail::getSettlementNo, item.getSettlementNo())
        );
    }

    @Override
    public boolean updateInvoiceStatusBySettlementNo(String settlementNo, Integer invoiceStatus){
        return update(lUdWrapper()
                .eq(SettlementOwnerDetail::getSettlementNo, settlementNo)
                .set(SettlementOwnerDetail::getInvoiceStatus, invoiceStatus)
        );
    }

    @Override
    public boolean updateFinalPaymentStatusBySettlementNo(String settlementNo, Integer finalPaymentStatus){
        return update(lUdWrapper()
                .eq(SettlementOwnerDetail::getSettlementNo, settlementNo)
                .set(SettlementOwnerDetail::getFinalPaymentStatus, finalPaymentStatus)
        );
    }

    @Override
    public Optional<SettlementOwnerDetail> getByChildNo(String childNo) {
        return Optional.of(childNo)
                .map(item -> lQrWrapper()
                        .eq(SettlementOwnerDetail::getChildNo, item)
                )
                .map(super::getOne);
    }
    @Override
    public List<SettlementOwnerDetail> getBySettlementNo(String settlementNo) {
        return list(lQrWrapper().eq(SettlementOwnerDetail::getSettlementNo, settlementNo));
    }

    @Override
    public List<SettlementOwnerDetail> getBySettlementNoAndInvoiceType(String settlementNo, Integer invoiceType, Integer invoiceStatus) {
        return list(lQrWrapper().eq(SettlementOwnerDetail::getSettlementNo, settlementNo)
                .eq(SettlementOwnerDetail::getInvoiceType, invoiceType)
                .eq(SettlementOwnerDetail::getInvoiceStatus, invoiceStatus)
        );
    }


    @Override
    public IPage<SettlementOwnerDetail> pageSettlementOwnerDetail(
            PageCarrierSettlementOwnerDetailParam param) {
        LambdaQueryWrapper<SettlementOwnerDetail> query = buildQuery(param);
        query.orderByDesc(SettlementOwnerDetail ::getCreateTime);
        return baseMapper.selectPage(Page.of(param.getPage(), param.getPageSize()),query);
    }

    private LambdaQueryWrapper<SettlementOwnerDetail> buildQuery(PageCarrierSettlementOwnerDetailParam param) {
        LambdaQueryWrapper<SettlementOwnerDetail> query = new LambdaQueryWrapper<>();
        if(StringUtils.isNotBlank(param.getChildNo())){
            query.eq(SettlementOwnerDetail :: getChildNo, param.getChildNo());
        }
        if(StringUtils.isNotBlank(param.getOrderNo())){
            query.eq(SettlementOwnerDetail :: getOrderNo, param.getOrderNo());
        }
        if(Objects.nonNull(param.getOwnerUserNo())){
            query.eq(SettlementOwnerDetail :: getOwnerUserNo, param.getOwnerUserNo());
        }
        if(Objects.nonNull(param.getOwnerUserName())){
            query.like(SettlementOwnerDetail :: getOwnerName, param.getOwnerUserName());
        }
        if(StringUtils.isNotBlank(param.getStartTime()) && StringUtils.isNotBlank(param.getEndTime())){
            query.between(SettlementOwnerDetail:: getCreateTime, param.getStartTime(), param.getEndTime());
        }else {
            query.between(SettlementOwnerDetail :: getCreateTime, LocalDateTimeUtil.now().minusMonths(3),LocalDateTimeUtil.now());
        }
        return query;
    }

    @Override
    public Integer getInvoiceType(String orderNo) {
        return baseMapper.getInvoiceType(orderNo);
    }

    @Override
    public void updateSettlementByChildNoList(List<String> childNoList) {
         update(lUdWrapper()
                .in(SettlementOwnerDetail::getChildNo, childNoList)
                .set(SettlementOwnerDetail::getInvoiceStatus, SettlementOwnerDetailEnum.InvoiceStatus.YES.getCode())
        );
    }

    @Override
    public void updateFinalPaymentStatusBySettlementNoForOnline(String settlementNo, Integer finalPaymentStatus) {
        update(lUdWrapper()
                .eq(SettlementOwnerDetail::getSettlementNo, settlementNo)
                .eq(SettlementOwnerDetail::getFinalPaymentStatus, SettlementOwnerDetailEnum.FinalPaymentStatus.NO.getCode())
                .set(SettlementOwnerDetail::getFinalPaymentStatus, finalPaymentStatus)

        );
    }

    @Override
    public List<SettlementOwnerDetail> selectListByOrderNo(String orderNo) {
        return baseMapper.selectList(lQrWrapper().eq(SettlementOwnerDetail::getOrderNo, orderNo)
                .isNull(SettlementOwnerDetail::getSettlementNo)
        );
    }

    @Override
    public IPage<SettlementOwnerDetail> pageOwnerSettlementOrderDetailList(PageOwnerSettlementOwnerDetailParam param) {
        LambdaQueryWrapper<SettlementOwnerDetail> query = new LambdaQueryWrapper<>();
        query.eq(SettlementOwnerDetail :: getSettlementNo,param.getSettlementNo());
        query.eq(StringUtils.isNotBlank(param.getChildNo()),SettlementOwnerDetail :: getChildNo,param.getChildNo());
        query.eq(StringUtils.isNotBlank(param.getOrderNo()),SettlementOwnerDetail :: getOrderNo,param.getOrderNo());
        query.eq(StringUtils.isNotBlank(param.getSettlementSubNo()),SettlementOwnerDetail :: getSettlementSubNo,param.getSettlementSubNo());
        return baseMapper.selectPage(Page.of(param.getPage(), param.getPageSize()),query);
    }

    @Override
    public IPage<SettlementOwnerDetail> pageInvoiceOwnerSettlementOrderDetailList(PageInvoiceOwnerSettlementOwnerDetailParam param) {
        LambdaQueryWrapper<SettlementOwnerDetail> query = new LambdaQueryWrapper<>();
        query.in(SettlementOwnerDetail :: getFinalPaymentStatus, SettlementOwnerDetailEnum.FinalPaymentStatus.YES,SettlementOwnerDetailEnum.FinalPaymentStatus.NO_REQUIRE);
        query.eq(SettlementOwnerDetail::getInvoiceStatus,param.getInvoiceStatus());
        query.eq(Objects.nonNull(param.getOwnerUserNo()),SettlementOwnerDetail::getOwnerUserNo,param.getOwnerUserNo());
        query.like(StringUtils.isNotBlank(param.getOwnerName()),SettlementOwnerDetail :: getOwnerName,param.getOwnerName());
        query.eq(StringUtils.isNotBlank(param.getSettlementNo()),SettlementOwnerDetail :: getSettlementNo,param.getSettlementNo());
        query.eq(StringUtils.isNotBlank(param.getChildNo()),SettlementOwnerDetail :: getChildNo,param.getChildNo());
        query.like(StringUtils.isNotBlank(param.getInvoicingCompanyShorterName()),SettlementOwnerDetail :: getInvoicingCompanyShorterName,param.getInvoicingCompanyShorterName());
        query.eq(Objects.nonNull(param.getInvoiceType()),SettlementOwnerDetail :: getInvoiceType,param.getInvoiceType());

        //待开票列表根据创建时间查找
        if (param.getInvoiceStatus().equals(SettlementOwnerDetailEnum.InvoiceStatus.NO.getCode())) {
            query.between(StringUtils.isNotBlank(param.getBeginTime()) && StringUtils.isNotBlank(param.getEndTime()),SettlementOwnerDetail::getCreateTime,param.getBeginTime(),param.getEndTime());
            query.between(StringUtils.isBlank(param.getBeginTime()) || StringUtils.isBlank(param.getEndTime()),SettlementOwnerDetail::getCreateTime,LocalDateTime.now().minusMonths(3),LocalDateTime.now());
        //已开票列表根据开票时间查找
        }else {
            query.between(StringUtils.isNotBlank(param.getBeginTime()) && StringUtils.isNotBlank(param.getEndTime()),SettlementOwnerDetail::getInvoiceTime,param.getBeginTime(),param.getEndTime());
            query.between(StringUtils.isBlank(param.getBeginTime()) || StringUtils.isBlank(param.getEndTime()),SettlementOwnerDetail::getInvoiceTime,LocalDateTime.now().minusMonths(3),LocalDateTime.now());
        }

        //待开票列表根据创建时间正序排，已开票列表根据开票时间倒序排
        query.orderByAsc(param.getInvoiceStatus().equals(SettlementOwnerDetailEnum.InvoiceStatus.NO.getCode()),SettlementOwnerDetail::getCreateTime);
        query.orderByDesc(param.getInvoiceStatus().equals(SettlementOwnerDetailEnum.InvoiceStatus.YES.getCode()),SettlementOwnerDetail::getInvoiceTime);

        return baseMapper.selectPage(Page.of(param.getPage(), param.getPageSize()),query);
    }

    @Override
    public void updateSettlementMerge(String settlementNo, List<String> settlementNos) {
         update(lUdWrapper()
                .in(SettlementOwnerDetail::getSettlementNo, settlementNos)
                .setSql("settlement_sub_no = settlement_no")
                .set(SettlementOwnerDetail :: getSettlementNo,settlementNo)
        );
    }

    @Override
    public List<SettlementOwnerDetail> listInvoiceStatusSync() {
        return list(lUdWrapper()
                .gt(SettlementOwnerDetail::getCreateTime, LocalDateTime.now().minusMonths(1))
                .eq(SettlementOwnerDetail::getInvoiceChannel, SettlementOwnerDetailEnum.InvoiceChannel.BROKER.getCode())
                .eq(SettlementOwnerDetail::getInvoiceStatus, SettlementOwnerDetailEnum.InvoiceStatus.NO.getCode())
                .eq(SettlementOwnerDetail::getPayStatus, SettlementOwnerDetailEnum.PayStatus.YES.getCode())
                .eq(SettlementOwnerDetail::getInvoiceType, SettlementOwnerEnum.InvoiceType.ONLINE.getCode())
        );
    }
    @Override
    public List<SettlementOwnerDetail> listPayStatusSync() {
        return list(lUdWrapper()
                .gt(SettlementOwnerDetail::getCreateTime, LocalDateTime.now().minusMonths(1))
                .eq(SettlementOwnerDetail::getInvoiceChannel, SettlementOwnerDetailEnum.InvoiceChannel.BROKER.getCode())
                .eq(SettlementOwnerDetail::getPayStatus, SettlementOwnerDetailEnum.PayStatus.NO.getCode())
                .eq(SettlementOwnerDetail::getInvoiceType, SettlementOwnerEnum.InvoiceType.ONLINE.getCode())
        );
    }

    @Override
    public List<SettlementOwnerDetail> listInvoiceTypeSync() {
        return list(lUdWrapper()
                .gt(SettlementOwnerDetail::getCreateTime, LocalDateTime.now().minusMonths(1))
                .le(SettlementOwnerDetail::getCreateTime, LocalDateTime.now().minusMinutes(3))
                .eq(SettlementOwnerDetail::getInvoiceChannel, SettlementOwnerDetailEnum.InvoiceChannel.BROKER.getCode())
                .isNull(SettlementOwnerDetail::getInvoiceType)
        );
    }

    @Override
    public IPage<SettlementOwnerDetail> pagePendingSettlementOwnerDetail(PagePendingCarrierSettlementOwnerDetailParam param) {
        LambdaQueryWrapper<SettlementOwnerDetail> query = buildQuery(param);
        query.eq(SettlementOwnerDetail::getInvoiceType,ORDINARY.getCode());
        //todo 演练数据不展示，根据上线时间排除
        if (Objects.equals(param.getHandleStatus(),NO.getCode())) {
            query.isNull(SettlementOwnerDetail::getInvoicingCompanyId);
        }else if (Objects.equals(param.getHandleStatus(),YES.getCode())){
            query.isNotNull(SettlementOwnerDetail::getInvoicingCompanyId);
        }
        query.orderByAsc(SettlementOwnerDetail ::getCreateTime);
        return baseMapper.selectPage(Page.of(param.getPage(), param.getPageSize()),query);
    }

    @Override
    public List<SettlementOwnerDetail> listSettlementOwnerDetailBySettlementNos(ExportBatchOwnerSettlementDetailParam param) {
        return list(lUdWrapper()
                .in(SettlementOwnerDetail::getSettlementNo, param.getSettlementNos())
        );
    }
}
