package com.clx.performance.controller.pc.owner;

import com.clx.performance.param.pc.owner.settle.OwnerSettlementOrderChildRiskProcessUpdateParam;
import com.clx.performance.service.settle.SettlementOrderChildRiskService;
import com.msl.common.result.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Slf4j
@RestController
@RequestMapping(value="/pc/owner/settlementOrderChildRisk")
@Validated
@Api(tags = "货主端-货主结算")
@AllArgsConstructor
public class OwnerSettlementOrderChildRiskController {

    private final SettlementOrderChildRiskService settlementOrderChildRiskService;

    @ApiOperation(value = "风控处理",notes = "<br>By:李瑞新")
    @PostMapping("/updateProcessRisk")
    public Result updateRiskProcess(@RequestBody @Validated OwnerSettlementOrderChildRiskProcessUpdateParam param) {
        settlementOrderChildRiskService.updateRiskProcess(param);
        return Result.ok();
    }

}
