package com.clx.performance.controller.pc;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.param.pc.ArtificialCancelOrderParam;
import com.clx.performance.param.pc.ArtificialCancelOrderQueryParam;
import com.clx.performance.param.pc.OrderCancelParam;
import com.clx.performance.param.pc.OrderChildCancelRecordParam;
import com.clx.performance.service.OrderCancelService;
import com.clx.performance.vo.app.OrderChildVO;
import com.clx.performance.vo.pc.OrderChildOperateRecordVO;
import com.msl.common.base.PageData;
import com.msl.common.result.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

@Slf4j
@RestController
@RequestMapping(value="/pc/order/")
@Validated
@Api(tags = "PC-订单取消")
@AllArgsConstructor
public class OrderCancelController {

    private final OrderCancelService orderCancelService;


//    @ApiOperation(value = "承运端取消订单", notes = "<br>By:胡宇帆")
//    @PostMapping("/platformCancelOrderPre")
//    public Result<Object> platformCancelOrderPre(@RequestBody OrderCancelParam param) {
//        orderCancelService.platformCancelOrderPre(param);
//        return Result.ok();
//    }

    @ApiOperation(value = "货主端取消订单", notes = "<br>By:胡宇帆")
    @PostMapping("/ownCancelOrderPre")
    public Result<Object> ownCancelOrderPre(@RequestBody OrderCancelParam param) {
        orderCancelService.ownerCancelOrderPre(param);
        return Result.ok();
    }

    @ApiOperation(value = "客服取消运单查询", notes = "<br>By:胡宇帆")
    @GetMapping("/findArtificialCancelOrder")
    public Result<OrderChildVO> findArtificialCancelOrder(ArtificialCancelOrderQueryParam param) {
        OrderChildVO vo = orderCancelService.findArtificialCancelOrder(param);
        return Result.ok(vo);
    }

    @ApiOperation(value = "客服取消运单", notes = "<br>By:胡宇帆")
    @PostMapping("/artificialCancelOrder")
    public Result<Object> artificialCancelOrder(@RequestBody ArtificialCancelOrderParam param) {
        orderCancelService.artificialCancelOrder(param.getOrderChildNo(), param.getRemark());
        return Result.ok();
    }


    @ApiOperation(value = "取消运单记录", notes = "<br>By:胡宇帆")
    @PostMapping("/orderChildCancelRecord")
    public Result<PageData<OrderChildVO>> orderChildCancelRecord(@RequestBody OrderChildCancelRecordParam param) {
        IPage<OrderChildVO> page = orderCancelService.orderChildCancelRecord(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }

    @ApiOperation(value = "运单处理记录", notes = "<br>By:姜武杰")
    @PostMapping("/orderChildOperateRecord")
    public Result<PageData<OrderChildOperateRecordVO>> orderChildOperateRecord(@RequestBody OrderChildCancelRecordParam param) {
        IPage<OrderChildOperateRecordVO> page = orderCancelService.orderChildOperateRecord(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }

    @ApiOperation(value = "客服解除装车限制", notes = "<br>By:姜武杰")
    @PostMapping("/artificialRemoveLoadLimit")
    public Result<Object> artificialRemoveLoadLimit(@RequestBody ArtificialCancelOrderParam param) {
        // TODO 待实现
        return Result.ok();
    }


}
