/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.asn1.cmp;

import cn.com.infosec.asn1.ASN1Encodable;
import cn.com.infosec.asn1.ASN1EncodableVector;
import cn.com.infosec.asn1.ASN1Sequence;
import cn.com.infosec.asn1.DERObject;
import cn.com.infosec.asn1.DERSequence;
import cn.com.infosec.asn1.cmp.PKIBody;
import cn.com.infosec.asn1.cmp.PKIHeader;

public class ProtectedPart
extends ASN1Encodable {
    private PKIHeader header;
    private PKIBody body;

    private ProtectedPart(ASN1Sequence seq) {
        this.header = PKIHeader.getInstance(seq.getObjectAt(0));
        this.body = PKIBody.getInstance(seq.getObjectAt(1));
    }

    public static ProtectedPart getInstance(Object o) {
        if (o instanceof ProtectedPart) {
            return (ProtectedPart)o;
        }
        if (o instanceof ASN1Sequence) {
            return new ProtectedPart((ASN1Sequence)o);
        }
        throw new IllegalArgumentException("Invalid object: " + o.getClass().getName());
    }

    public PKIHeader getHeader() {
        return this.header;
    }

    public PKIBody getBody() {
        return this.body;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.header);
        v.add(this.body);
        return new DERSequence(v);
    }
}

